{ Copyright (C) 1988 Adam Fritz, 133 Main St., Afton, NY 13730 }

program IncrementalCosine (output) ;

     { IncCos - computes 2 * cos for angles 360/n scaled   }
     {          Bxx and lists those for which number of    }
     {          distinct bits are two or fewer.            }

type
   hexstr = string[9] ;

{~~~~~~~~~~~~~~~~~~~~ count set bits ~~~~~~~~~~~~~~~~~~~~~~}

function nBits ( n : longint ) : integer ;
var
   iBits : integer ;
begin
   iBits := 0 ;
   while n <> 0 do begin
      if Odd(n) then
         Inc(iBits) ;
      n := n shr 1
   end ;
   nBits := iBits
end ;

{~~~~~~~~~~~~~ convert integer to hex string ~~~~~~~~~~~~~~}

procedure itoh ( var sn : hexstr ; n : longint ) ;
const
   hexchr : array[0..15] of char = ('0','1','2','3','4','5','6','7',
                                    '8','9','A','B','C','D','E','F') ;
var
   lsn : hexstr ;
   ih,nh : integer ;
begin
   lsn := '' ;
   if abs(n) < 65536 then
      nh := 4
   else
      nh := 8 ;
   for ih := 1 to nh do begin
      lsn := hexchr[n and $000F] + lsn ;
      n := n shr 4
   end ;
   sn := '$' + lsn
end ;

{~~~~~~~~~~~~~~~~~~~~~ main program ~~~~~~~~~~~~~~~~~~~~~~~}

var
   ib : integer ;
   is : longint ;
   n : integer ;
   pit2 : single ;

   da,dad,cosda,sinda : single ;
   icosda,i2cosda : longint ;
   ni2cosda,nida : integer ;
   sicosda,si2cosda : hexstr ;

   ada,adad,cosada,sinada : single ;
   isinada : longint ;
   sisinada : hexstr ;

   r : longint ;

begin
   pit2 := 2.0 * Pi ;
                                { get scale }
   repeat
      write ('Scale: ') ;
      readln (ib)
   until (ib >= 0) and (ib < 31) ;
   is := longint(1) shl ib ;

   n := 4 ;
   r := 0 ;
   repeat
                                { incremental angle }
      Inc(n) ;
      da := pit2 / n ;
      cosda := cos(da) ;
                                { scale Bxx }
      icosda := Round(cosda * is) ;
      i2cosda := Round(2.0 * cosda * is) ;
                                { count distinct bits }
      ni2cosda := nBits(i2cosda) ;
      if ni2cosda > ib div 2 then
         ni2cosda := ni2cosda - ib - 1 ;
      nida := abs(ni2cosda) ;
                                { hex strings }
      if nida < 2 then begin
         itoh(sicosda,icosda) ;
         itoh(si2cosda,i2cosda) ;
         dad := da * 180.0 / Pi ;
         cosada := icosda / is ;
         sinada := sqrt(1.0-sqr(cosada)) ;
         if cosada > 0.0 then
            ada := arctan(sinada/cosada)
         else
            ada := Pi / 2 ;
         adad := ada * 180.0 / Pi ;
         r := Round(4.0/sqr(ada)) ;
         isinada := Round(sinada * is) ;
         itoh(sisinada,isinada) ;
         writeln (output,n:4,' ',dad:10:5,
                  '   ',sisinada,'   ',sicosda,'   ',si2cosda,
                  ' ',adad:10:5,' ',r:5,
                  ' ',ni2cosda:4,' ',nida:4)
      end
   until (n = 512) or (r > 2000)
end.

{ Copyright (C) 1988 Adam Fritz, 133 Main St., Afton, NY 13730 }
