{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }

procedure StrokeEllipse ( xc, yc : integer ; { center }
                            a, b : word ; { radii }
                              ta : single ) ; { rotation angle (rad) }

     { ElipRAI2 - draw ellipse using rotation angle method }
     {            with `increment' angle step and semi-    }
     {            circular symmetry                        }

var
   ixar,iyar        : word ;    { aspect ratio parameters }
   iar              : longint ; { aspect ratio B16 }
   icosta,isinta    : longint ; { rotation angle functions B16 }
   ira,irb          : longint ; { offset radii B6 }
   ida              : integer ; { loop control }
   it,ixa,iya       : longint ; { coordinate variables B6 }
   ixb,iyb          : longint ; { coordinate variables B6 }
   ix0,iy0,ix1,iy1  : integer ; { display coordinates B0 }

begin
                                { constraint test }
   if (a < 510) and (b < 510) then begin
                                { aspect ratio }
      GetAspectRatio(ixar,iyar) ;
      iar := SwapLong(longint(ixar)) div longint(iyar) ;
                                { rotate, offset, prescale, }
                                { aspect and reflect        }
      icosta := Round(cos(ta) * 65536) ;
      isinta := Round(sin(ta) * 65536) ;

      ira := a shl 6 + idr ;
      irb := b shl 6 + idr ;

      ixa := RoundScaleB16(ira * icosta) ;
      iya := -RoundScaleB16(irb * isinta) ;

      ixb := RoundScaleB16(RoundScaleB16(irb * icosta) * iar) ;
      iyb := -RoundScaleB16(RoundScaleB16(ira * isinta) * iar) ;
                                { starting point }
      ix0 := RoundScaleB6(ixa) ;
      iy0 := RoundScaleB6(iyb) ;
                                { ellipse }
      for ida := 1 to 25 do begin
                                { rotate coordinates }
         it := RoundScaleB16(((((ixa shl 3 - iya) shl 4 -
               ixa) shl 5 - iya) shl 2 - iya) shl 2) ;
         iya := RoundScaleB16(((((iya shl 3 + ixa) shl 4 -
                iya) shl 5 + ixa) shl 2 + ixa) shl 2) ;
         ixa := it ;

         it := RoundScaleB16(((((ixb shl 3 - iyb) shl 4 -
               ixb) shl 5 - iyb) shl 2 - iyb) shl 2) ;
         iyb := RoundScaleB16(((((iyb shl 3 + ixb) shl 4 -
                iyb) shl 5 + ixb) shl 2 + ixb) shl 2) ;
         ixb := it ;
                                { draw chord }
         ix1 := RoundScaleB6(ixa) ;
         iy1 := RoundScaleB6(iyb) ;
         Line(xc+ix0,yc+iy0,xc+ix1,yc+iy1) ;
         Line(xc-ix0,yc-iy0,xc-ix1,yc-iy1) ;
                                { ladder down }
         ix0 := ix1 ;  iy0 := iy1

      end
   end
end ;

{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }
