{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }

procedure StrokeEllipse ( xc, yc : integer ; { center }
                            a, b : word ; { radii }
                              ta : single ) ; { rotation angle (rad) }

     { ElipMB - Modified Bresenham ellipse algorithm }

var
   Color            : word ;    { default color }
   px,py            : single ;  { coordinate aspect variables }
   pxx,pyy          : single ;  { coordinate offset increments }
   ix,iy            : integer ; { display coordinates }
   idex,idey        : longint ; { error offset counters }
   idexx,ideyy      : longint ; { error offset increments }
   ie,iex,iey       : longint ; { error variables }

begin

   if (a > 0) and (b > 0) then begin

      Color := GetColor ;
                                { initialize assuming 3/2 aspect }
      px := 3 * GetMaxY ;
      py := 2 * GetMaxX ;
                                { scaling parameters }
      if px > py then begin
         py := py / px ;
         px := 1.0
      end
      else begin
         px := px / py ;
         py := 1.0
      end ;

      pxx := sqr(b*px) ;
      pyy := sqr(a*py) ;
                                { starting point and error }
      ix := 0 ;
      idex := Round(pxx) ;
      idexx := Round(2*pxx) ;
      iy := Round(b * px / py) ;
      idey := -Round((2*iy-1) * pyy) ;
      ideyy := Round(2*pyy) ;
      ie := 0 ;
                                { diameter points }
      PutPixel(xc,yc+iy,Color) ;
      PutPixel(xc,yc-iy,Color) ;
                               { octant points - 2,3,6,7 }
      while idex < -idey do begin

         Inc(ie,idex) ;
         Inc(idex,idexx) ;
         Inc(ix) ;
         iey := ie + idey ;
         if abs(ie) >= abs(iey) then begin
            ie := iey ;
            Inc(idey,ideyy) ;
            Dec(iy)
         end ;

         PutPixel(xc+ix,yc+iy,Color) ;
         PutPixel(xc+ix,yc-iy,Color) ;
         PutPixel(xc-ix,yc+iy,Color) ;
         PutPixel(xc-ix,yc-iy,Color)

      end ;
                                { octant points - 1,4,5,8 }
      while -idey > 0 do begin

         Inc(ie,idey) ;
         Inc(idey,ideyy) ;
         Dec(iy) ;
         iex := ie + idex ;
         if abs(ie) >= abs(iex) then begin
            ie := iex ;
            Inc(idex,idexx) ;
            Inc(ix)
         end ;

         PutPixel(xc+ix,yc+iy,Color) ;
         PutPixel(xc+ix,yc-iy,Color) ;
         PutPixel(xc-ix,yc+iy,Color) ;
         PutPixel(xc-ix,yc-iy,Color)

      end
   end
end ;

{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }
