{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }

program DefectCount (output) ;

     {    DfctCirc - draw circle with a stroke routine,    }
     {               erases reference circle, and count    }
     {               remaining set pixels.                 }

uses GRAPH ;

var
   xc,yc            : integer ; { center }
   ar               : single ;  { aspect ratio }

{~~~~~~~~~~~~~~~~~~~~~ circle routines ~~~~~~~~~~~~~~~~~~~~}

{$I conic.pas }

{-$I circda2.pas  }
{-$I circdaf.pas }
{-$I circdai.pas }
{-$I circdai2.pas }
{-$I circdam2.pas }
{-$I circdas.pas }
{-$I circmb.pas }
{$I circra.pas }
{-$I circraf4.pas }
{-$I circrai2.pas }
{-$I circrair.pas }
{-$I circram.pas }
{-$I circras.pas }

{~~~~~~~~~~~~~~~~~~~ number of defects ~~~~~~~~~~~~~~~~~~~~}

function CountDefects ( r : integer ) : integer ;
var
   n,ix,iy : integer ;
begin
   n := 0 ;
   for ix := xc-r-1 to xc+r+1 do
      for iy := yc-Round(r*ar)-1 to yc+Round(r*ar)+1 do
         if GetPixel(ix,iy) <> 0 then
            Inc(n) ;
   CountDefects := n
end ;

{~~~~~~~~~~~~~~~~~~~~~ main program ~~~~~~~~~~~~~~~~~~~~~~~}

var
   r                : word ;    { circle radius }
   grDetect, grMode : integer ; { graph control parameters }
   ixar,iyar        : word ;    { aspect ratio parameters }
   Color            : word ;
   i                : integer ;
   nDefects         : array[8..24] of integer ;

begin
                                { prompt for radius }
   repeat
      write ('Radius: ') ;
      readln (r)
   until (r > 0) ;
                                { initiate graphics }
   grDetect := Detect ;
   InitGraph(grDetect,grMode,'') ;
   GetAspectRatio(ixar,iyar) ;
   ar := ixar/iyar ;
                                { center of display }
   xc := (GetMaxX + 1) div 2 ;
   yc := (GetMaxY + 1) div 2 ;
                                { performance }
   for i := 8 to 24 do begin
      idr := 2*i ;
      dr := idr/64 ;
      ClearDevice ;
                                { draw stroke circle }
      StrokeCircle(xc,yc,r) ;
                                { clear TURBO BGI circle }
      Color := GetColor ;
      SetColor(0) ;
      Circle(xc,yc,r) ;
      SetColor(Color) ;
                                { count set pixels }
      nDefects[i] := CountDefects(r)

   end ;
                                { pause }
   CloseGraph ;
                                { show offset and defect count }
   writeln (output,'Radius: ',r) ;
   for i := 8 to 24 do begin
      idr := 2*i ;
      dr := idr/64 ;
      writeln (output,idr:5,'   ',dr:5:2,' ',nDefects[i]:5)
   end

end.

{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }
