{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }

const
   dr : single = 0.5 ;
   idr : integer = 32 ;

type
   lohi = record loint : integer ; hiint : integer ; end ;

{**********************************************************}

   function SwapLong ( n : longint ) : longint ;
      { interchange high and low order 16 bit words }
   var
      m : integer ;
      nlohi         : lohi absolute n ;
   begin
      m := nlohi.loint ;
      nlohi.loint := nlohi.hiint ;
      nlohi.hiint := m ;
      SwapLong := n
   end ;

{**********************************************************}

   function LongHi ( n : longint ) : longint ;
      { move high order 16 bits to low with sign extend }
   var
      nlohi         : lohi absolute n ;
   begin
      nlohi.loint := nlohi.hiint ;
      if n >= 0 then
         nlohi.hiint := 0
      else
         nlohi.hiint := -1 ;
      LongHi := n
   end ;

{**********************************************************}

   function RoundScaleB3 ( n : integer ) : integer ;
      { round and scale to B0 a fixed point value scaled B3 }
   begin
      if n >= 0 then
         RoundScaleB3 := (n + 4) div 8
      else
         RoundScaleB3 := (n - 4) div 8
   end ;

{**********************************************************}

   function RoundScaleB6 ( n : integer ) : integer ;
      { round and scale to B0 a fixed point value scaled B6 }
   begin
      if n >= 0 then
         RoundScaleB6 := (n + 32) div 64
      else
         RoundScaleB6 := (n - 32) div 64
   end ;

{**********************************************************}

   function RoundScaleB16 ( n : longint ) : longint ;
      { round and scale to B0 a fixed point value scaled B16 }
   var
      nlohi         : lohi absolute n ;
   begin
      if n >= 0 then begin
         n := n + 32768 ;
         nlohi.loint := nlohi.hiint ;
         nlohi.hiint := 0
      end
      else begin
         n := n - 32768 ;
         nlohi.loint := nlohi.hiint ;
         nlohi.hiint := -1
      end ;
      RoundScaleB16 := n
   end ;

{**********************************************************}

   function sinh ( x : single ) : single ;
     { hyperbolic sine }
   begin
      sinh := (exp(x) - exp(-x))/2.0
   end ;

   function cosh ( x : single ) : single ;
      { hyperbolic cosine }
   begin
      cosh := (exp(x) + exp(-x))/2.0
   end ;

{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }
