{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }

procedure StrokeCircle ( xc, yc : integer ; r : word ) ;

     { CircDAS - draw circular point constellation using   }
     {           difference angle method and `strange'     }
     {           angle step                                }

const
   icosda : longint = $2000 ;
   isinda : longint = $7BEF ;

var
   Color            : word ;    { default color }
   ir               : longint ; { offset radius B6 }
   ixar,iyar        : word ;    { aspect ratio parameters }
   iar              : longint ; { aspect ratio B16 }
   ida              : integer ; { loop control }
   ixa0,ixa1,ixa2   : longint ; { coordinate variables B22 }
   iya0,iya1,iya2   : longint ; { coordinate variables B22 }

begin
                                { constraint test }
   if r < 512 then begin
                                { aspect ratio }
      Color := GetColor ;
      GetAspectRatio(ixar,iyar) ;
      iar := SwapLong(longint(ixar)) div longint(iyar) ;
                                { offset, prescale, aspect, }
                                { and reflect               }
      ir := r shl 6 + idr ;
      ixa2 := ir * icosda shl 1 ;
      ixa1 := SwapLong(ir) ;
      iya2 := -LongHi(ir * isinda shl 1) * iar ;
      iya1 := 0 ;
                                { circle }
      for ida := 1 to r do begin
                                { step coordinates }
         ixa0 := ixa1 div 2 - ixa2 ;
         iya0 := iya1 div 2 - iya2 ;
                                { show pixel }
         PutPixel(xc+RoundScaleB6(LongHi(ixa0)),
                  yc+RoundScaleB6(LongHi(iya0)),Color) ;
                                { ladder down }
         ixa2 := ixa1 ;  iya2 := iya1 ;
         ixa1 := ixa0 ;  iya1 := iya0

      end
   end
end ;

{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }
