{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }

procedure StrokeCircle ( xc, yc : integer ; r : word ) ;

     { CircDAF - draw circle using difference angle method }
     {           and fixed point arithmetic                }

var
   ixar,iyar        : word ;    { aspect ratio parameters }
   iar              : longint ; { aspect ratio B16 }
   da,cosda         : single ;  { step angle and function }
   icosda,isinda    : longint ; { step angle functions B16 }
   icosdat2         : longint ; { generator coefficient B16 }
   ida,nda          : integer ; { loop control }
   ir               : longint ; { offset radius B6 }
   ixa0,ixa1,ixa2   : integer ; { coordinate variables B6 }
   iya0,iya1,iya2   : integer ; { coordinate variables B6 }
   ix0,iy0          : integer ; { display variables B0 }

begin
                                { constraint test }
   if r < 510 then begin
                                { aspect ratio }
      GetAspectRatio(ixar,iyar) ;
      iar := SwapLong(longint(ixar)) div longint(iyar) ;
                                { step angle and functions }
      da := 2.0 * sqrt(1.0/r) ;
      nda := Round(2.0 * Pi / da) ;
      if Odd(nda) then Inc(nda) ;
      da := 2.0 * Pi / nda ;
      cosda := cos(da) ;
      icosda := Round(cosda * 65536) ;
      isinda := Round(sin(da) * 65536) ;
      icosdat2 := Round(cosda * 131072) ;
                                { initialize differences and offset }
      ir := r shl 6 + idr ;
      ixa2 := RoundScaleB16(ir * icosda) ;
      ixa1 := ir ;
      iya2 := -RoundScaleB16(LongHi(ir * isinda) * iar) ;
      iya1 := 0 ;
                                { starting point }
      ix0 := RoundScaleB6(ir) ;
      iy0 := 0 ;
      MoveTo(xc+ix0,yc) ;
                                { circle }
      for ida := 1 to nda-1 do begin
                                { rotate coordinates }
         ixa0 := RoundScaleB16(icosdat2 * ixa1) - ixa2 ;
         iya0 := RoundScaleB16(icosdat2 * iya1) - iya2 ;
                                { chord }
         LineTo(xc+RoundScaleB6(ixa0),yc+RoundScaleB6(iya0)) ;
                                { ladder down }
         ixa2 := ixa1 ;  ixa1 := ixa0 ;
         iya2 := iya1 ;  iya1 := iya0

      end ;
                                { closure }
      LineTo(xc+ix0,yc+iy0)

   end
end ;

{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }
