{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }

program BenchEllipse (output) ;

     { BnchElip - compare stroke ellipse and BGI ellipse   }
     {            generation times                         }

uses GRAPH, DOS ;

{~~~~~~~~~~~~~~~~~~~~ ellipse routine ~~~~~~~~~~~~~~~~~~~~~}

{$I conic.pas }

{-$I elipda2.pas }
{$I elipdaf.pas }
{-$I elipdai.pas }
{-$I elipdam.pas }
{-$I elipmb.pas }
{-$I elipmbr.pas }
{-$I elipra.pas }
{-$I elipra2.pas }
{-$I elipraf.pas }
{-$I elipraf2.pas }
{-$I eliprai2.pas }
{-$I elipram.pas }

{~~~~~~~~~~~~~~~~~~~~~ main program ~~~~~~~~~~~~~~~~~~~~~~~}

const
   nEllipse = 100 ;

var
   i : integer ;
   xc,yc : integer ;
   Hour,Min,Sec,CentiSec : array[0..2] of word ;
   Time : array[0..2] of single ;
   dTimeEllipse,dTimeStroke : single ;
   grDetect,grMode : integer ;

begin
   grDetect := Detect ;
   InitGraph(grDetect,grMode,'') ;
   xc := (GetMaxX + 1) shr 1 ;
   yc := (GetMaxY + 1) shr 1 ;
   Randomize ;
   GetTime(Hour[0],Min[0],Sec[0],CentiSec[0]) ;
                                { TURBO Bresenham }
   ClearDevice ;
   for i := 1 to nEllipse do
      Ellipse(Random(GetMaxX),Random(GetMaxY),0,360,
                Random(xc),Random(yc)) ;
   GetTime(Hour[1],Min[1],Sec[1],CentiSec[1]) ;
                                { stroke ellipse }
   ClearDevice ;
   for i := 1 to nEllipse do
      StrokeEllipse(Random(GetMaxX),Random(GetMaxY),
                      Random(xc),Random(yc),Pi*Random) ;
   GetTime(Hour[2],Min[2],Sec[2],CentiSec[2]) ;
   CloseGraph ;
                                { convert times to seconds }
   for i := 0 to 2 do
      Time[i] := (Hour[i] * 60.0 + Min[i]) * 60.0 +
                     Sec[i] + CentiSec[i]/100.0 ;
                                { compute average drawing times }
   dTimeEllipse := (Time[1] - Time[0])/nEllipse ;
   dTimeStroke := (Time[2] - Time[1])/nEllipse ;

   writeln (output,'Ellipse: ',dTimeEllipse:8:5,'   ',
                   'Stroke: ',dTimeStroke:8:5)

end.

{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }
