{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }

procedure StrokeParabola ( xf, yf : integer ; { focus }
                                p : word ; { parameter }
                               ta : single ) ; { rotation angle (rad) }

     { ParaRAF - draw parabola using rotation of coordinates }
     {           and fixed point arithmetic                  }

const
   iONEB16 : longint = $10000 ;
   iONEB14 : longint = $4000 ;
   iONEB12 : longint = $1000 ;

var
   ixar,iyar        : word ;    { aspect ratio parameters }
   iar              : longint ; { aspect ratio B16 }
   icosta,isinta    : longint ; { rotation angle functions B15 }
   iacosta,iasinta  : longint ; { rotation angle functions - aspect B15 }
   xx,yx,rx         : single ;  { coordinate limits }
   ax               : single ;  { maximum polar angle }
   it,icosa,isina   : longint ; { polar angle functions B14 }
   da               : single ;  { step angle }
   icosda,isinda    : longint ; { step angle functions B15 }
   ida,nda          : word ;    { loop control }
   ip               : longint ; { parameter B19 }
   ir               : longint ; { polar radius B3 }
   ircosa,irsina    : longint ; { polar coordinate factors B3 }
   ixp1,iyp1,ixp2,iyp2 : longint ; { coordinate variables B3 }
   ix0,iy0,ix1,iy1,ix2,iy2,ix3,iy3 : integer ; { display variables B0 }

begin
                                { ignore rectilinear parabola }
   if (p > 0) and (p < iONEB12) then begin
                                { aspect ratio }
      GetAspectRatio(ixar,iyar) ;
      iar := SwapLong(longint(ixar)) div longint(iyar) ;
                                { coordinate variables with }
                                { aspect and reflection     }
      icosa := iONEB14 ;
      isina := 0 ;
      icosta := Round(cos(ta) * 32768) ;
      isinta := Round(sin(ta) * 32768) ;
      iacosta := RoundScaleB16(icosta * iar) ;
      iasinta := RoundScaleB16(isinta * iar) ;
                                { starting point }
      ip := SwapLong(longint(p) shl 3) ;
      ir := RoundScaleB16(ip shr 1) ;
      ix0 := xf + RoundScaleB3(RoundScaleB16(ir * icosta shl 1)) ;
      iy0 := yf - RoundScaleB3(RoundScaleB16(ir * iasinta shl 1)) ;
      ix2 := ix0 ;
      iy2 := iy0 ;
                                { coordinate limits }
      if xf > 0 then
         if xf > GetMaxX + 1 then
            xx := xf
         else
            if xf > GetMaxX div 2 then
               xx := xf
            else
               xx := GetMaxX - xf
      else
         xx := abs(xf) + GetMaxX + 1 ;

      if yf > 0 then
         if yf > GetMaxY + 1 then
            yx := yf
         else
            if yf > GetMaxY div 2 then
               yx := yf
            else
               yx := GetMaxY - yf
      else
         yx := abs(yf) + GetMaxY + 1 ;
                                { step angle and functions }
      rx := sqrt(sqr(xx) + sqr(yx)) ;
      da := 2.0 * sqrt(1.0/rx) ;
      ax := Pi - sqrt(2.0*p/rx) ;
      nda := Round(ax/da) ;
      da := ax/nda ;
      icosda := Round(cos(da) * 32768) ;
      isinda := Round(sin(da) * 32768) ;

      for ida := 1 to nda do begin
                                { polar angle functions }
         it := RoundScaleB16((icosa * icosda - isina * isinda) shl 1) ;
         isina := RoundScaleB16((isina * icosda + icosa * isinda) shl 1) ;
         icosa := it ;
                                { polar radius }
         ir := ip div (iONEB16 + icosa shl 2) ;
                                { rotation terms }
         ircosa := RoundScaleB16(ir * icosa shl 2) ;
         irsina := RoundScaleB16(ir * isina shl 2) ;

         ixp1 := RoundScaleB16(ircosa * icosta shl 1) ;
         ixp2 := RoundScaleB16(irsina * isinta shl 1) ;
         iyp1 := RoundScaleB16(irsina * iacosta shl 1) ;
         iyp2 := RoundScaleB16(ircosa * iasinta shl 1) ;
                                { display coordinates }
         ix1 := xf + RoundScaleB3(ixp1 - ixp2) ;
         iy1 := yf - RoundScaleB3(iyp1 + iyp2) ;
         ix3 := xf + RoundScaleB3(ixp1 + ixp2) ;
         iy3 := yf + RoundScaleB3(iyp1 - iyp2) ;
                                { draw chords }
         Line(ix0,iy0,ix1,iy1) ;
         Line(ix2,iy2,ix3,iy3) ;
                                { ladder down }
         ix0 := ix1 ;  iy0 := iy1 ;
         ix2 := ix3 ;  iy2 := iy3

      end
   end
end ;

{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }
