{ Copyright (C) 1988 Adam Fritz, 133 Main St., Afton, NY 13730 }

program MinimumCosine (output) ;

     {    MinCos - Compute 2 * cosine scaled Bxx and list  }
     {             distinct set bit counts.                }

type
   hexstr = string[9] ;

{~~~~~~~~~~~~~~~~~~~~ count set bits ~~~~~~~~~~~~~~~~~~~~~~}

function nBits ( n : longint ) : integer ;
var
   iBits : integer ;
begin
   iBits := 0 ;
   while n <> 0 do begin
      if Odd(n) then
         Inc(iBits) ;
      n := n shr 1
   end ;
   nBits := iBits
end ;

{~~~~~~~~~~~ convert integer to hex string ~~~~~~~~~~~~~~~~}

procedure itoh ( var sn : hexstr ; n : longint ) ;
const
   hexchr : array[0..15] of char = ('0','1','2','3','4','5','6','7',
                                    '8','9','A','B','C','D','E','F') ;
var
   lsn : hexstr ;
   ih,nh : integer ;
begin
   lsn := '' ;
   if abs(n) < 65536 then
      nh := 4
   else
      nh := 8 ;
   for ih := 1 to nh do begin
      lsn := hexchr[n and $000F] + lsn ;
      n := n shr 4
   end ;
   sn := '$' + lsn
end ;

{~~~~~~~~~~~~~~~~~~~~~ main program ~~~~~~~~~~~~~~~~~~~~~~~}

var
   ib : integer ;
   is : longint ;
   nda : integer ;
   da,dad,sinda,cosda : single ;
   isinda,icosda,i2cosda : longint ;
   nisinda, ni2cosda, nida : integer ;
   sisinda,sicosda,si2cosda : hexstr ;
   r : longint ;

begin
                                { get scale }
   repeat
      write ('Scale: ') ;
      readln (ib)
   until (ib >= 0) and (ib < 31) ;
   is := longint(1) shl ib ;

   i2cosda := 511 ;
   r := 0 ;
   repeat
                                { sine and cosine }
      Inc(i2cosda) ;
      cosda := i2cosda / (2*is) ;
      sinda := sqrt(1.0 - sqr(cosda)) ;
                                { count distinct set bits }
      ni2cosda := nBits(i2cosda) ;
      if ni2cosda > ib div 2 then
         ni2cosda := ni2cosda - ib - 1 ;
      nida := abs(ni2cosda) ;
                                { hex strings }
      if nida < 2 then begin
         itoh(si2cosda,i2cosda) ;
         icosda := Round(cosda * is) ;
         itoh(sicosda,icosda) ;
         if cosda <> 0.0 then
            da := arctan(sinda/cosda)
         else
            da := Pi / 2.0 ;
         r := Round(4.0/sqr(da)) ;
         dad := da / Pi * 180.0 ;
         nda := Round(2.0 * Pi / da) ;
         isinda := Round(sinda * is) ;
         itoh(sisinda,isinda) ;
         writeln (output,nda:3,' ',dad:10:5,' ',r:5,
                  '   ',sisinda,'   ',sicosda,'   ',si2cosda,
                  ' ',ni2cosda:4,' ',nida:4)
      end
   until (i2cosda = 2*is-1) or (r > 2000)
end.

{ Copyright (C) 1988 Adam Fritz, 133 Main St., Afton, NY 13730 }
