{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }

program StrokeCircleClosureDemo (output) ;

     {    LeakCRAF - determine whether stroke circle       }
     {               routine using rotation angle method   }
     {               and fixed point arithmetic closes     }

uses GRAPH ;

{$I conic.pas }

var
     nLeak          : integer ; { number of leaks }
     nOverflow      : integer ; { number of overflows }

{**********************************************************}

procedure StrokeCircle ( xc, yc : integer ; r : word ) ;

     { CircRAF - draw circle using rotation angle method   }
     {           and floating point arithmetic             }

var
   ixar,iyar        : word ;    { aspect ratio parameters }
   iar              : longint ; { aspect ratio B16 }
   da               : single ;  { step angle }
   icosda,isinda    : longint ; { step angle functions B16 }
   ida,nda,ndad4    : integer ; { loop control }
   it,ix,iy         : longint ; { coordinate variables B6 }
   ix0,iy0,ix1,iy1 : integer ; { display variables }

begin
                                { constraint test }
   if r < 512 then begin
                                { aspect ratio }
      GetAspectRatio(ixar,iyar) ;
      iar := SwapLong(longint(ixar)) div longint(iyar) ;
                                { step angle and functions }
      da := 2.0 * sqrt(1.0/r) ;
      nda := Round(2.0 * Pi / da) ;
      if Odd(nda) then Inc(nda) ;
      da := 2.0 * Pi / nda ;
      icosda := Round(cos(da) * 65536) ;
      isinda := Round(sin(da) * 65536) ;
                                { starting point with offset }
      ix := r shl 6 + idr ;
      iy := 0 ;
      ix0 := RoundScaleB6(ix) ;
      iy0 := 0 ;
                                { circle }
      for ida := 1 to nda do begin
                                { rotate coordinates }
         it := RoundScaleB16(ix * icosda - iy * isinda) ;
         iy := RoundScaleB16(ix * isinda + iy * icosda) ;
         ix := it ;
                                { aspect ratio }
         ix1 := RoundScaleB6(ix) ;
         iy1 := RoundScaleB6(LongHi(iy * iar)) ;

      end
   end ;
                                { report closure }
   if (abs(ix0-ix1) > 1) or (abs(iy0-iy1) > 1) then begin
      if (ix1 < 0) or (iy1 < 0) then
         Inc(nOverflow)
      else
         Inc(nLeak) ;
      writeln (output,r:5,' ',nda:5,' ',ix1:5,' ',iy1:5) ;
   end

end ;

{********************* main program ***********************}

var
   grDriver,grMode  : integer ;  { graphics mode control }
   r                : integer ;  { circle radius }
   xc, yc           : integer ;  { circle center }
   i                : integer ;  { loop control }

begin

   grDriver := Detect ;
   InitGraph(grDriver,grMode,'') ;
   CloseGraph ;
                                { center of display }
   xc := (GetMaxX + 1) div 2 ;
   yc := (GetMaxY + 1) div 2 ;
                                { offset survey }
   for i := 8 to 24 do begin
      idr := 2*i ;
      dr := idr/64 ;
      nLeak := 0 ;
      nOverflow := 0 ;
                                { radius survey }
      for r := 500 to 511 do
         StrokeCircle(xc,yc,r) ;
                                { report closure and overflow problems }
      writeln (output,idr:5,'   ',dr:5:2,' ',nLeak:5,' ',nOverflow:5)
   end

end.

{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }
