{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }

procedure StrokeHyperbola ( xc, yc : integer ; { center }
                              a, b : word ; { radii }
                                ta : single ) ; { rotation angle (rad) }

     { HyprRA - draw ellipse using rotation angle method   }

var
   ixar,iyar        : word ;    { aspect ratio parameters }
   ar               : single ;  { aspect ratio }
   costa,sinta      : single ;  { rotation angle functions }
   acosta,asinta    : single ;  { rottion angle functions - aspect }
   dx,coshdx,sinhdx : single ;  { step and functions }
   t,xa,ya,xb,yb    : single ;  { coordinate variables }
   xx,yx            : single ;  { coordinate limits }
   r,idx,ndx        : integer ; { loop control }
   ix0,iy0,ix1,iy1  : integer ; { display variables }
   ix2,iy2,ix3,iy3  : integer ; { display variables }

begin
                                { aspect ratio }
   GetAspectRatio(ixar,iyar) ;
   ar := ixar/iyar ;
                                { step and functions }
   if a > b then
      r := a
   else
      r := b ;
   dx := 2.0 * sqrt(1.0/r) ;
   coshdx := cosh(dx) ;
   sinhdx := sinh(dx) ;

   if xc > 0 then
      if xc > GetMaxX + 1 then
         xx := xc
      else
         if xc > GetMaxX div 2 then
            xx := xc
         else
            xx := GetMaxX - xc
   else
      xx := abs(xc) + GetMaxX + 1 ;

   if yc > 0 then
      if yc > GetMaxY + 1 then
         yx := yc
      else
         if yc > GetMaxY div 2 then
            yx := yc
         else
            yx := GetMaxY - yc
   else
      yx := abs(yc) + GetMaxY + 1 ;

   ndx := Round(ln(2*sqrt(sqr(xx)+sqr(yx))/r)/ln(coshdx+dx)) ;
                                { rotation angle functions }
   costa := cos(ta) ;
   sinta := sin(ta) ;
   acosta := ar * costa ;
   asinta := ar * sinta ;
                                { offset }
   xa := a + dr ;
   ya := 0.0 ;
   xb := b + dr ;
   yb := 0.0 ;
                                { starting points }
   ix0 := Round(costa * xa) ;
   iy0 := Round(-sinta * xa * ar) ;
   ix2 := ix0 ;
   iy2 := iy0 ;
                                { hyperbola }
   for idx := 1 to ndx do begin
                                { step coordinates }
      t := xa * coshdx + ya * sinhdx ;
      ya := xa * sinhdx + ya * coshdx ;
      xa := t ;

      t := xb * coshdx + yb * sinhdx ;
      yb := xb * sinhdx + yb * coshdx ;
      xb := t ;
                                { rotate coordinates }
      ix1 := Round(costa * xa + sinta * yb) ;
      iy1 := Round(-asinta * xa + acosta * yb) ;
      Line(xc+ix0,yc+iy0,xc+ix1,yc+iy1) ;
      Line(xc-ix0,yc-iy0,xc-ix1,yc-iy1) ;
                                { second branch }
      ix3 := Round(costa * xa - sinta * yb) ;
      iy3 := Round(-asinta * xa - acosta * yb) ;
      Line(xc+ix2,yc+iy2,xc+ix3,yc+iy3) ;
      Line(xc-ix2,yc-iy2,xc-ix3,yc-iy3) ;
                                { ladder down }
      ix2 := ix3 ;  iy2 := iy3 ;
      ix0 := ix1 ;  iy0 := iy1

   end
end ;

{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }
