{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }

procedure StrokeHyperbola ( xc, yc : integer ; { center }
                              a, b : word ; { radii }
                                ta : single ) ; { rotation angle (rad) }

     { HyprMBR - draw hyperbola using modified Bresenham with }
     {           rotation and aspect correction               }

const
   s = 8.0 ;

var
   Color            : word ;    { default color }
   a2,b2            : single ;  { radii parameters }
   costa,costa2     : single ;  { rotation angle parameters }
   sinta,sinta2     : single ;  {            "              }
   px,py            : single ;  { aspect variables }
   pxx,pxy,pyy      : single ;  {        "         }
   x0,y0            : single ;  { starting point, float }
   ix0,iy0          : integer ; {        "      , fixed }
   ix,iy            : integer ; { coordinate variables }
   ixx,iyx          : integer ; { coordinate limits }
   ie,iex,iey       : longint ; { error variables }
   idex,idey        : longint ; { error offsets }
   idex0,idey0      : longint ; {       "      , initial }
   idexx,idexy      : longint ; { error increments }
   ideyx,ideyy      : longint ; {        "         }

begin
                                { ignore rectilinear hyperbola }
   if (a > 0) and (b > 0) then begin

      a2 := sqr(a) ;
      b2 := sqr(b) ;

      Color := GetColor ;
                                { aspect ratio parameters }
      px := 3 * GetMaxY ;
      py := 2 * GetMaxX ;
      if px > py then begin
         py := s * py / px ;
         px := s
      end
      else begin
         px := s * px / py ;
         py := s
      end ;
                                { rotation angle functions }
      costa := cos(ta) ;
      costa2 := sqr(costa) ;
      sinta := sin(ta) ;
      sinta2 := sqr(sinta) ;

      pxx := sqr(px)*(b2*costa2 - a2*sinta2) ;
      pxy := px*py*(a2+b2)*sinta*costa ;
      pyy := sqr(py)*(b2*sinta2 - a2*costa2) ;
                                { error increments }
      idexx := Round(2*pxx) ;
      idexy := Round(2*pxy) ;
      ideyx := idexy ;
      ideyy := Round(2*pyy) ;
                                { coordinate limits }
      if xc > 0 then
         if xc > GetMaxX + 1 then
            ixx := xc
         else
            if xc > GetMaxX div 2 then
               ixx := xc
            else
               ixx := GetMaxX - xc
      else
         ixx := abs(xc) + GetMaxX + 1 ;

      if yc > 0 then
         if yc > GetMaxY + 1 then
            iyx := yc
         else
            if yc > GetMaxY div 2 then
               iyx := yc
            else
               iyx := GetMaxY - yc
      else
         iyx := abs(yc) + GetMaxY + 1 ;
                                { step in y }
      if abs(sinta) < abs(costa) then begin
                                { starting coordinates }
         x0 := a*costa ;
         y0 := a*sinta*px/py ;
         if x0 < 0.0 then begin
            x0 := -x0 ;
            y0 := -y0
         end ;
         ix0 := Round(x0) ;
         iy0 := Round(y0) ;

         idex0 := Round((2*x0+1)*pxx + 2*y0*pxy) ;
         idey0 := Round((2*y0+1)*pyy + 2*x0*pxy) ;
                                { starting point }
         ix := ix0 ;
         iy := iy0 ;
         ie := 0 ;
                                { vertex point }
         PutPixel(xc+ix,yc-iy,Color) ;
         PutPixel(xc-ix,yc+iy,Color) ;

         idex := -idex0 + idexx ;
         idey := idey0 ;
                                { vertex to dy = 0 }
         while (idey > 0) and
                 (abs(ix) < ixx) and (abs(iy) < iyx) do begin

            Inc(ie,idey) ;
            Inc(idey,ideyy) ;
            Inc(iy) ;
            Dec(idex,idexy) ;
            iex := ie + idex ;
            if abs(ie) > abs(iex) then begin
               Inc(idex,idexx) ;
               Dec(ix) ;
               Dec(idey,ideyx) ;
               ie := iex
            end ;

            PutPixel(xc+ix,yc-iy,Color) ;
            PutPixel(xc-ix,yc+iy,Color)

         end ;

         idex := -idex + idexx ;
                                { dy = 0 to dx = dy }
         while (idex > -idey) and
                 (abs(ix) < ixx) and (abs(iy) < iyx) do begin

            Inc(ie,idey) ;
            Inc(idey,ideyy) ;
            Inc(iy) ;
            Inc(idex,idexy) ;
            iex := ie + idex ;
            if abs(ie) > abs(iex) then begin
               Inc(idex,idexx) ;
               Inc(ix) ;
               Inc(idey,ideyx) ;
               ie := iex
            end ;

            PutPixel(xc+ix,yc-iy,Color) ;
            PutPixel(xc-ix,yc+iy,Color)

         end ;
                                { dx = xy to dy = 0 }
         while (idex > 0) and
                 (abs(ix) < ixx) and (abs(iy) < iyx) do begin

            Inc(ie,idex) ;
            Inc(idex,idexx) ;
            Inc(ix) ;
            Inc(idey,ideyx) ;
            iey := ie + idey ;
            if abs(ie) > abs(iey) then begin
               Inc(idey,ideyy) ;
               Inc(iy) ;
               Inc(idex,idexy) ;
               ie := iey
            end ;

            PutPixel(xc+ix,yc-iy,Color) ;
            PutPixel(xc-ix,yc+iy,Color)

         end ;

         idey := -idey + ideyy ;
                                { dy = 0 to asymptote }
         while (abs(ix) < ixx) and (abs(iy) < iyx) do begin

            Inc(ie,idex) ;
            Inc(idex,idexx) ;
            Inc(ix) ;
            Dec(idey,ideyx) ;
            iey := ie + idey ;
            if abs(ie) > abs(iey) then begin
               Inc(idey,ideyy) ;
               Dec(iy) ;
               Dec(idex,idexy) ;
               ie := iey
            end ;

            PutPixel(xc+ix,yc-iy,Color) ;
            PutPixel(xc-ix,yc+iy,Color)

         end ;
                                { reinitialize }
         ix := ix0 ;
         iy := iy0 ;
         ie := 0 ;

         idex := -idex0 + idexx ;
         idey := -idey0 + ideyy ;
                                { vertex to dy = 0 }
         while (idey > 0) and
                 (abs(ix) < ixx) and (abs(iy) < iyx) do begin

            Inc(ie,idey) ;
            Inc(idey,ideyy) ;
            Dec(iy) ;
            Inc(idex,idexy) ;
            iex := ie + idex ;
            if abs(ie) > abs(iex) then begin
               Inc(idex,idexx) ;
               Dec(ix) ;
               Inc(idey,ideyx) ;
               ie := iex
            end ;

            PutPixel(xc+ix,yc-iy,Color) ;
            PutPixel(xc-ix,yc+iy,Color)

         end ;

         idex := -idex + idexx ;
                                { dy = 0 to dx = dy }
         while (idex > -idey) and
                 (abs(ix) < ixx) and (abs(iy) < iyx) do begin

            Inc(ie,idey) ;
            Inc(idey,ideyy) ;
            Dec(iy) ;
            Dec(idex,idexy) ;
            iex := ie + idex ;
            if abs(ie) > abs(iex) then begin
               Inc(idex,idexx) ;
               Inc(ix) ;
               Dec(idey,ideyx) ;
               ie := iex
            end ;

            PutPixel(xc+ix,yc-iy,Color) ;
            PutPixel(xc-ix,yc+iy,Color)

         end ;
                                { dx = xy to dy = 0 }
         while (idex > 0) and
                 (abs(ix) < ixx) and (abs(iy) < iyx) do begin

            Inc(ie,idex) ;
            Inc(idex,idexx) ;
            Inc(ix) ;
            Dec(idey,ideyx) ;
            iey := ie + idey ;
            if abs(ie) > abs(iey) then begin
               Inc(idey,ideyy) ;
               Dec(iy) ;
               Dec(idex,idexy) ;
               ie := iey
            end ;

            PutPixel(xc+ix,yc-iy,Color) ;
            PutPixel(xc-ix,yc+iy,Color)

         end ;

         idey := -idey + ideyy ;
                                { dy = 0 to asymptote }
         while (abs(ix) < ixx) and (abs(iy) < iyx) do begin

            Inc(ie,idex) ;
            Inc(idex,idexx) ;
            Inc(ix) ;
            Inc(idey,ideyx) ;
            iey := ie + idey ;
            if abs(ie) > abs(iey) then begin
               Inc(idey,ideyy) ;
               Inc(iy) ;
               Inc(idex,idexy) ;
               ie := iey
            end ;

            PutPixel(xc+ix,yc-iy,Color) ;
            PutPixel(xc-ix,yc+iy,Color)

         end
      end
                                { step in x }
      else begin
                                { starting coordinates }
         x0 := a*costa ;
         y0 := a*sinta*px/py ;
         if y0 < 0.0 then begin
            x0 := -x0 ;
            y0 := -y0
         end ;
         ix0 := Round(x0) ;
         iy0 := Round(y0) ;

         idex0 := Round((2*x0+1)*pxx + 2*y0*pxy) ;
         idey0 := Round((2*y0+1)*pyy + 2*x0*pxy) ;
                                { starting point }
         ix := ix0 ;
         iy := iy0 ;
         ie := 0 ;
                                { vertex point }
         PutPixel(xc+ix,yc-iy,Color) ;
         PutPixel(xc-ix,yc+iy,Color) ;

         idex := idex0 ;
         idey := -idey0 + ideyy ;
                                { vertex to dy = 0 }
         while (idex > 0) and
                 (abs(ix) < ixx) and (abs(iy) < iyx) do begin

            Inc(ie,idex) ;
            Inc(idex,idexx) ;
            Inc(ix) ;
            Dec(idey,ideyx) ;
            iey := ie + idey ;
            if abs(ie) > abs(iey) then begin
               Inc(idey,ideyy) ;
               Dec(iy) ;
               Dec(idex,idexy) ;
               ie := iey
            end ;

            PutPixel(xc+ix,yc-iy,Color) ;
            PutPixel(xc-ix,yc+iy,Color)

         end ;

         idey := -idey + ideyy ;
                                { dy = 0 to dx = dy }
         while (idey > -idex) and
                 (abs(ix) < ixx) and (abs(iy) < iyx) do begin

            Inc(ie,idex) ;
            Inc(idex,idexx) ;
            Inc(ix) ;
            Inc(idey,ideyx) ;
            iey := ie + idey ;
            if abs(ie) > abs(iey) then begin
               Inc(idey,ideyy) ;
               Inc(iy) ;
               Inc(idex,idexy) ;
               ie := iey
            end ;

            PutPixel(xc+ix,yc-iy,Color) ;
            PutPixel(xc-ix,yc+iy,Color)

         end ;
                                { dx = xy to dx = 0 }
         while (idey > 0) and
                 (abs(ix) < ixx) and (abs(iy) < iyx) do begin

            Inc(ie,idey) ;
            Inc(idey,ideyy) ;
            Inc(iy) ;
            Inc(idex,idexy) ;
            iex := ie + idex ;
            if abs(ie) > abs(iex) then begin
               Inc(idex,idexx) ;
               Inc(ix) ;
               Inc(idey,ideyx) ;
               ie := iex
            end ;

            PutPixel(xc+ix,yc-iy,Color) ;
            PutPixel(xc-ix,yc+iy,Color)

         end ;

         idex := -idex + idexx ;
                                { dx = 0 to asymptote }
         while (abs(ix) < ixx) and (abs(iy) < iyx) do begin

            Inc(ie,idey) ;
            Inc(idey,ideyy) ;
            Inc(iy) ;
            Dec(idex,idexy) ;
            iex := ie + idex ;
            if abs(ie) > abs(iex) then begin
               Inc(idex,idexx) ;
               Dec(ix) ;
               Dec(idey,ideyx) ;
               ie := iex
            end ;

            PutPixel(xc+ix,yc-iy,Color) ;
            PutPixel(xc-ix,yc+iy,Color)

         end ;
                                { reinitialize }
         ix := ix0 ;
         iy := iy0 ;
         ie := 0 ;

         idex := -idex0 + idexx ;
         idey := -idey0 + ideyy ;
                                { vertex to dy = 0 }
         while (idex > 0) and
                 (abs(ix) < ixx) and (abs(iy) < iyx) do begin

            Inc(ie,idex) ;
            Inc(idex,idexx) ;
            Dec(ix) ;
            Inc(idey,ideyx) ;
            iey := ie + idey ;
            if abs(ie) > abs(iey) then begin
               Inc(idey,ideyy) ;
               Dec(iy) ;
               Inc(idex,idexy) ;
               ie := iey
            end ;

            PutPixel(xc+ix,yc-iy,Color) ;
            PutPixel(xc-ix,yc+iy,Color)

         end ;

         idey := -idey + ideyy ;
                                { dy = 0 to dx = dy }
         while (idey > -idex) and
                 (abs(ix) < ixx) and (abs(iy) < iyx) do begin

            Inc(ie,idex) ;
            Inc(idex,idexx) ;
            Dec(ix) ;
            Dec(idey,ideyx) ;
            iey := ie + idey ;
            if abs(ie) > abs(iey) then begin
               Inc(idey,ideyy) ;
               Inc(iy) ;
               Dec(idex,idexy) ;
               ie := iey
            end ;

            PutPixel(xc+ix,yc-iy,Color) ;
            PutPixel(xc-ix,yc+iy,Color)

         end ;
                                { dx = dy to dx = 0 }
         while (idey > 0) and
                 (abs(ix) < ixx) and (abs(iy) < iyx) do begin

            Inc(ie,idey) ;
            Inc(idey,ideyy) ;
            Inc(iy) ;
            Dec(idex,idexy) ;
            iex := ie + idex ;
            if abs(ie) > abs(iex) then begin
               Inc(idex,idexx) ;
               Dec(ix) ;
               Dec(idey,ideyx) ;
               ie := iex
            end ;

            PutPixel(xc+ix,yc-iy,Color) ;
            PutPixel(xc-ix,yc+iy,Color)

         end ;

         idex := -idex + idexx ;
                                { dx = 0 to asymptote }
         while (abs(ix) < ixx) and (abs(iy) < iyx) do begin

            Inc(ie,idey) ;
            Inc(idey,ideyy) ;
            Inc(iy) ;
            Inc(idex,idexy) ;
            iex := ie + idex ;
            if abs(ie) > abs(iex) then begin
               Inc(idex,idexx) ;
               Inc(ix) ;
               Inc(idey,ideyx) ;
               ie := iex
            end ;

            PutPixel(xc+ix,yc-iy,Color) ;
            PutPixel(xc-ix,yc+iy,Color)

         end
      end
   end
end ;

{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }
