{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }

procedure StrokeHyperbola ( xc, yc : integer ; { center }
                              a, b : word ; { radii }
                                ta : single ) ; { rotation angle (rad) }

     { HyprDAM - draw hyperbola using difference angle     }
     {           method and `minimum' angle step           }

const
   dx = 0.08836 ;
   coshdx = 1.00390 ;
   isinhdx : longint = $16A6 ;
   icoshdx : longint = $10100 ;

var
   ixar,iyar        : word ;    { aspect ratio parameters }
   iar              : longint ; { aspect ratio B16 }
   xx,yx            : single ;  { coordinate limits }
   r,idx,ndx        : integer ; { loop control }
   ixa0,ixa1,ixa2   : longint ; { generator B0 }
   iyb0,iyb1,iyb2   : longint ; { generator B0 }
   icosta,isinta    : longint ; { rotation B15 }
   iacosta,iasinta  : longint ; { rotation - aspect B15 }
   ix0,iy0,ix1,iy1  : integer ; { display variables B0 }
   ix2,iy2,ix3,iy3  : integer ; { display variables B0 }

begin
                                { aspect ratio }
   GetAspectRatio(ixar,iyar) ;
   iar := SwapLong(longint(ixar)) div longint(iyar) ;
                                { step }
   if a > b then
      r := a
   else
      r := b ;

   if xc > 0 then
      if xc > GetMaxX + 1 then
         xx := xc
      else
         if xc > GetMaxX div 2 then
            xx := xc
         else
            xx := GetMaxX - xc
   else
      xx := abs(xc) + GetMaxX + 1 ;

   if yc > 0 then
      if yc > GetMaxY + 1 then
         yx := yc
      else
         if yc > GetMaxY div 2 then
            yx := yc
         else
            yx := GetMaxY - yc
   else
      yx := abs(yc) + GetMaxY + 1 ;

   ndx := Round(ln(2*sqrt(sqr(xx)+sqr(yx))/r)/ln(coshdx+dx)) ;
                                { offset and initialize }
                                { difference equations  }
   ixa1 := SwapLong(longint(a)) ;
   ixa2 := longint(a) * icoshdx ;
   iyb1 := 0 ;
   iyb2 := -longint(b) * isinhdx ;
                                { aspect and rotation }
   icosta := Round(cos(ta) * 32768) ;
   isinta := Round(sin(ta) * 32768) ;
   iacosta := RoundScaleB16(iar * icosta) ;
   iasinta := RoundScaleB16(iar * isinta) ;
                                { starting points }
   ix0 := RoundScaleB16(LongHi(ixa1) * icosta shl 1) ;
   iy0 := -RoundScaleB16(LongHi(ixa1) * iasinta shl 1) ;
   ix2 := ix0 ;
   iy2 := iy0 ;
                                { hyperbola }
   for idx := 1 to ndx do begin
                                { step coordinates }
      ixa0 := (ixa1 + ixa1 shr 8) shl 1 - ixa2 ;
      iyb0 := (iyb1 + iyb1 shr 8) shl 1 - iyb2 ;

      ix1 := RoundScaleB16((LongHi(ixa0) * icosta +
              LongHi(iyb0) * isinta) shl 1) ;
      iy1 := RoundScaleB16((-LongHi(ixa0) * iasinta +
              LongHi(iyb0) * iacosta) shl 1) ;

      Line(xc+ix0,yc+iy0,xc+ix1,yc+iy1) ;
      Line(xc-ix0,yc-iy0,xc-ix1,yc-iy1) ;

      ix3 := RoundScaleB16((LongHi(ixa0) * icosta -
              LongHi(iyb0) * isinta) shl 1);
      iy3 := RoundScaleB16((-LongHi(ixa0) * iasinta -
              LongHi(iyb0) * iacosta) shl 1);

      Line(xc+ix2,yc+iy2,xc+ix3,yc+iy3) ;
      Line(xc-ix2,yc-iy2,xc-ix3,yc-iy3) ;
                                { ladder down }
      ixa2 := ixa1 ;  ixa1 := ixa0 ;
      iyb2 := iyb1 ;  iyb1 := iyb0 ;
      ix0 := ix1 ;  iy0 := iy1 ;
      ix2 := ix3 ;  iy2 := iy3

   end
end ;

{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }
