{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }

procedure StrokeHyperbola ( xc, yc : integer ; { center }
                              a, b : word ; { radii }
                                ta : single ) ; { rotation angle (rad) }

     { HyprDA - draw hyperbola using difference angle method }

var
   ixar,iyar        : word ;    { aspect ratio parameters }
   ar               : single ;  { aspect ratio }
   dx,coshdx        : single ;  { step and function }
   coshdxt2         : single ;  { difference equation coefficient }
   xx,yx            : single ;  { coordinate limits }
   r,idx,ndx        : integer ; { loop control }
   xa0,xa1,xa2      : single ;  { cosh generator }
   yb0,yb1,yb2      : single ;  { sinh generator }
   costa,sinta      : single ;  { rotation variables }
   acosta,asinta    : single ;  {           "       , aspect }
   ix0,iy0,ix1,iy1  : integer ; { display variables }
   ix2,iy2,ix3,iy3  : integer ; {         "         }

begin
                                { aspect ratio }
   GetAspectRatio(ixar,iyar) ;
   ar := ixar/iyar ;
                                { step angle and functions }
   if a > b then
      r := a
   else
      r := b ;
   dx := 2.0 * sqrt(1.0/r) ;
   coshdx := cosh(dx) ;
   coshdxt2 := coshdx * 2.0 ;

   if xc > 0 then
      if xc > GetMaxX + 1 then
         xx := xc
      else
         if xc > GetMaxX div 2 then
            xx := xc
         else
            xx := GetMaxX - xc
   else
      xx := abs(xc) + GetMaxX + 1 ;

   if yc > 0 then
      if yc > GetMaxY + 1 then
         yx := yc
      else
         if yc > GetMaxY div 2 then
            yx := yc
         else
            yx := GetMaxY - yc
   else
      yx := abs(yc) + GetMaxY + 1 ;

   ndx := Round(ln(2*sqrt(sqr(xx)+sqr(yx))/r)/ln(coshdx+dx)) ;
                                { offset and initialize }
                                { difference equations  }
   xa1 := (a+0.5) ;
   xa2 := (a+0.5) * coshdx ;
   yb1 := 0.0 ;
   yb2 := -(b+0.5) * sinh(dx) ;
                                { aspect and rotation }
   costa := cos(ta) ;
   sinta := sin(ta) ;
   acosta := ar * costa ;
   asinta := ar * sinta ;
                                { starting points }
   ix0 := Round(xa1 * costa) ;
   iy0 := Round(-xa1 * asinta) ;
   ix2 := ix0 ;
   iy2 := iy0 ;
                                { hyperbola }
   for idx := 1 to ndx do begin
                                { step coordinates }
      xa0 := coshdxt2 * xa1 - xa2 ;
      yb0 := coshdxt2 * yb1 - yb2 ;

      ix1 := Round(xa0 * costa + yb0 * sinta) ;
      iy1 := Round(-xa0 * asinta + yb0 * acosta) ;

      Line(xc+ix0,yc+iy0,xc+ix1,yc+iy1) ;
      Line(xc-ix0,yc-iy0,xc-ix1,yc-iy1) ;

      ix3 := Round(xa0 * costa - yb0 * sinta) ;
      iy3 := Round(-xa0 * asinta - yb0 * acosta) ;

      Line(xc+ix2,yc+iy2,xc+ix3,yc+iy3) ;
      Line(xc-ix2,yc-iy2,xc-ix3,yc-iy3) ;
                                { ladder down }
      xa2 := xa1 ;  xa1 := xa0 ;
      yb2 := yb1 ;  yb1 := yb0 ;
      ix0 := ix1 ;  iy0 := iy1 ;
      ix2 := ix3 ;  iy2 := iy3

   end
end ;

{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }
