{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }

procedure StrokeEllipse ( xc, yc : integer ; { center }
                            a, b : word ; { radii }
                              ta : single ) ; { rotation angle (rad) }

     { ElipRA - draw ellipse using rotation angle method }

var
   ixar,iyar        : word ;    { aspect ratio parameters }
   ar               : single ;  { aspect ratio }
   da,cosda,sinda   : single ;  { step angle and functions }
   t,xa,ya,xb,yb    : single ;  { coordinate variables }
   r,ida,nda        : integer ; { loop control }

begin
                                { aspect ratio }
   GetAspectRatio(ixar,iyar) ;
   ar := ixar/iyar ;
                                { step angle and functions }
   if a > b then
      r := a
   else
      r := b ;
   da := 2.0 * sqrt(1.0/r) ;
   nda := Round(2.0 * Pi / da) ;
   if Odd(nda) then Inc(nda) ;
   da := 2.0 * Pi / nda ;
   cosda := cos(da) ;
   sinda := sin(da) ;
                                { coordinate variables with }
                                { rotation, offset, aspect, }
                                { prescale and reflection   }
   xa := (a+dr) * cos(ta) ;
   ya := -(b+dr) * sin(ta) ;
   xb := (b+dr) * cos(ta) * ar ;
   yb := -(a+dr) * sin(ta) * ar ;
                                { starting point }
   MoveTo(xc+Round(xa),yc+Round(yb)) ;
                                { ellipse }
   for ida := 1 to nda do begin
                                { rotate coordinates }
      t := xa * cosda - ya * sinda ;
      ya := xa * sinda + ya * cosda ;
      xa := t ;

      t := xb * cosda - yb * sinda ;
      yb := xb * sinda + yb * cosda ;
      xb := t ;
                                { draw chord }
      LineTo(xc+Round(xa),yc+Round(yb))

   end
end ;

{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }
