{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }

procedure StrokeEllipse ( xc, yc : integer ; { center }
                            a, b : word ; { radii }
                              ta : single ) ; { rotation angle (rad) }

     { ElipDAM - draw ellipse using difference angle       }
     {           method and `minimum' angle step           }

const
   isinda : longint = $1FF4 ;
   icosda : longint = $FE00 ;

var
   ixar,iyar        : word ;    { aspect ratio parameters }
   iar              : longint ; { aspect ratio B16 }
   ida              : integer ; { loop control }
   ira,irb          : longint ; { radii offset and scaled B6 }
   ixa0,ixa1,ixa2   : longint ; { cosine generator variables B22 }
   iyb0,iyb1,iyb2   : longint ; { sine generator variables B22 }
   icosta,isinta    : longint ; { rotation parameters B10 }
   iacosta,iasinta  : longint ; { rotation parameters - aspect B10 }
   ix0,iy0,ix1,iy1  : integer ; { display variables B0 }

begin
                                { constraint test }
   if (a < 512) and (b < 512) then begin
                                { aspect ratio }
      GetAspectRatio(ixar,iyar) ;
      iar := SwapLong(longint(ixar)) div longint(iyar) ;
                                { offset, prescale, reflect }
      ira := a shl 6 + idr ;
      ixa1 := SwapLong(ira) ;
      ixa2 := ira * icosda ;
      irb := b shl 6 + idr ;
      iyb1 := 0 ;
      iyb2 := -irb * isinda ;
                                { aspect and rotation }
      icosta := Round(cos(ta) * 1024) ;
      isinta := Round(sin(ta) * 1024) ;
      iacosta := RoundScaleB16(iar * icosta) ;
      iasinta := RoundScaleB16(iar * isinta) ;
                                { starting point }
      ix0 := RoundScaleB16(LongHi(ixa1) * icosta) ;
      iy0 := -RoundScaleB16(LongHi(ixa1) * iasinta) ;
      MoveTo(xc+ix0,yc+iy0) ;
                                { ellipse }
      for ida := 1 to 49 do begin
                                { step coordinates }
         ixa0 := (ixa1 - ixa1 div 128) shl 1 - ixa2 ;
         iyb0 := (iyb1 - iyb1 div 128) shl 1 - iyb2 ;
                                { rotate }
         ix1 := RoundScaleB16(LongHi(ixa0) * icosta +
                 LongHi(iyb0) * isinta) ;
         iy1 := RoundScaleB16(-LongHi(ixa0) * iasinta +
                 LongHi(iyb0) * iacosta) ;
                                { draw stroke }
         LineTo(xc+ix1,yc+iy1) ;
                                { ladder down }
         ixa2 := ixa1 ;  ixa1 := ixa0 ;
         iyb2 := iyb1 ;  iyb1 := iyb0

      end ;
                                { closure }
      LineTo(xc+ix0,yc+iy0)

   end
end ;

{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }
