{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }

procedure StrokeEllipse ( xc, yc : integer ; { center }
                            a, b : word ; { radii }
                              ta : single ) ; { rotation angle (rad) }

     { ElipDA2 - draw stroke ellipse using difference      }
     {           angle method and semi-circular symmetry   }

var
   ixar,iyar        : word ;    { aspect ratio parameters }
   ar               : single ;  { aspect ratio }
   r                : word ;    { effective radius }
   da,cosda,sinda   : single ;  { step angle and functions }
   ida,ndad2        : integer ; { loop control }
   cosdat2          : single ;  { difference equation coefficient }
   xa0,xa1,xa2      : single ;  { cosine generator variables }
   yb0,yb1,yb2      : single ;  { sine generator variables }
   costa,sinta      : single ;  { rotation variables }
   acosta,asinta    : single ;  { rotation variables - aspect }
   ix0,iy0,ix1,iy1  : integer ; { display variables }

begin
                                { aspect ratio }
   GetAspectRatio(ixar,iyar) ;
   ar := ixar/iyar ;
                                { step angle functions }
   if a > b then
      r := a
   else
      r := b ;
   da := 2.0 * sqrt(1.0/r) ;
   ndad2 := Round(Pi / da) ;
   da := Pi / ndad2 ;
   cosda := cos(da) ;
   cosdat2 := cosda * 2.0 ;
                                { offset, prescale, reflect }
   xa1 := a + dr ;
   xa2 := (a+dr) * cosda ;
   yb1 := 0.0 ;
   yb2 := - (b+dr) * sin(da) ;
                                { aspect and rotation }
   costa := cos(ta) ;
   sinta := sin(ta) ;
   acosta := ar * costa ;
   asinta := ar * sinta ;
                                { starting point }
   ix0 := Round(xa1 * costa) ;
   iy0 := -Round(xa1 * asinta) ;
                                { ellipse }
   for ida := 1 to ndad2 do begin
                                { step coordinates }
      xa0 := cosdat2 * xa1 - xa2 ;
      yb0 := cosdat2 * yb1 - yb2 ;
                                { rotate }
      ix1 := Round(xa0 * costa + yb0 * sinta) ;
      iy1 := Round(-xa0 * asinta + yb0 * acosta) ;
                                { semi-elliptic symmetry }
      Line(xc+ix0,yc+iy0,xc+ix1,yc+iy1) ;
      Line(xc-ix0,yc-iy0,xc-ix1,yc-iy1) ;
                                { ladder down }
      xa2 := xa1 ;  xa1 := xa0 ;
      yb2 := yb1 ;  yb1 := yb0 ;
      ix0 := ix1 ;  iy0 := iy1

   end
end ;

{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }
