{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }

program StrokePolygonDemo ;

     {    DemoPoly - draw regular polygon with given radius, }
     {               number of sides, and rotation angle.    }

uses GRAPH ;

{~~~~~~~~~~~~~~~~~~~~ polygon routine ~~~~~~~~~~~~~~~~~~~~~}

{$I conic.pas }

{-$I polyra.pas }
{-$I polyraf.pas }
{-$I polyda.pas }
{$I polydaf.pas }

{~~~~~~~~~~~~~~~~~~~~~ main program ~~~~~~~~~~~~~~~~~~~~~~~}

var
   grDriver,grMode  : integer ; { graph control parameters }
   r                : word ;    { polygon radius }
   n                : word ;    { number of sides }
   ta,tad           : single ;  { rotation angle }
   xc, yc           : integer ; { polygon center }

begin
                                { prompt for radius }
   repeat
      write ('Radius: ') ;
      readln (r)
   until (r > 0) ;
                                { prompt for number of sides }
   repeat
      write ('Number of sides: ') ;
      readln (n)
   until (n > 2) ;
                                { prompt for rotation angle }
   repeat
      write ('Rotation angle (deg): ') ;
      readln (tad)
   until (tad >= 0.0) and (tad <  360.0) ;
   ta := tad / 180.0 * Pi ;
                                { initiate graphics }
   grDriver := Detect ;
   InitGraph(grDriver,grMode,'') ;
                                { center of display }
   xc := (GetMaxX+1) div 2 ;
   yc := (GetMaxY+1) div 2 ;
                                { draw polygon }
   StrokePolygon(xc,yc,r,n,ta) ;
                                { leak test }
   FloodFill(xc,yc,GetMaxColor) ;
                                { pause }
   readln ;
   CloseGraph

end.

{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }
