{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }

procedure StrokeCircle ( xc, yc : integer ; r : word ) ;

     { CircRAIR - draw circle using rotation angle method, }
     {            `increment' angle step, fraction machine }
     {            scaling, and semi-circular symmetry      }

var
   ixar,iyar        : word ;    { aspect ratio parameters }
   iar              : longint ; { aspect ratio B16 }
   ida              : integer ; { loop control }
   it,ix,iy         : longint ; { coordinate variables B22 }
   ix0,iy0,ix1,iy1,ix2,iy2 : integer ; { display coordinates B0 }

begin
                                { constraint test }
   if r < 512 then begin
                                { aspect ratio }
      GetAspectRatio(ixar,iyar) ;
      iar := SwapLong(longint(ixar)) div longint(iyar) ;
                                { prescale }
      ix := SwapLong(r shl 6 + idr) ;
      iy := 0 ;
                                { starting point }
      ix0 := RoundScaleB6(LongHi(ix)) ;
      iy0 := 0 ;
      ix1 := ix0 ;
      iy1 := iy0 ;
                                { circle }
      for ida := 1 to 24 do begin
                                { rotate coordinates }
         it := (((-iy div 4 - iy) div 32 - ix) div 16 - iy) div 8 + ix ;
         iy := ((( ix div 4 + ix) div 32 - iy) div 16 + ix) div 8 + iy ;
         ix := it ;
                                { semi-circular symmetry }
         ix2 := RoundScaleB6(LongHi(ix)) ;
         iy2 := RoundScaleB6(LongHi(LongHi(iy) * iar)) ;
         Line(xc+ix1,yc+iy1,xc+ix2,yc+iy2) ;
         Line(xc-ix1,yc-iy1,xc-ix2,yc-iy2) ;
                                { ladder down }
         ix1 := ix2 ;  iy1 := iy2

      end ;
                                { closure }
      Line(xc+ix2,yc+iy2,xc-ix0,yc-iy0) ;
      Line(xc-ix2,yc-iy2,xc+ix0,yc+iy0)

   end
end ;

{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }
