{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }

procedure StrokeCircle ( xc, yc : integer ; r : word ) ;

     { CircRAF4 - draw circle using rotation angle method, }
     {            fixed point arithmetic, and quadrant     }
     {            symmetry                                 }

var
   ixar,iyar        : word ;    { aspect ratio parameters }
   iar              : longint ; { aspect ratio B16 }
   da               : single ;  { step angle }
   icosda,isinda    : longint ; { step angle functions B16 }
   ida,nda,ndad4    : integer ; { loop control }
   it,ix,iy         : longint ; { coordinate variables B6 }
   ix0,iy0,ix1,iy1  : integer ; { display variables }

begin
                                { constraint test }
   if r < 512 then begin
                                { aspect ratio }
      GetAspectRatio(ixar,iyar) ;
      iar := SwapLong(longint(ixar)) div longint(iyar) ;
                                { step angle and functions }
      da := 2.0 * sqrt(1.0/r) ;
      nda := Round(2.0 * Pi / da) ;
      ndad4 := (nda + 3) div 4 ;
      nda := ndad4 shl 2 ;
      da := 2.0 * Pi / nda ;
      icosda := Round(cos(da) * 65536) ;
      isinda := Round(sin(da) * 65536) ;
                                { starting point with offset }
      ix := r shl 6 + idr ;
      iy := 0 ;
      ix0 := RoundScaleB6(ix) ;
      iy0 := 0 ;
                                { circle }
      for ida := 1 to ndad4 do begin
                                { rotate coordinates }
         it := RoundScaleB16(ix * icosda - iy * isinda) ;
         iy := RoundScaleB16(ix * isinda + iy * icosda) ;
         ix := it ;
                                { aspect ratio }
         ix1 := RoundScaleB6(ix) ;
         iy1 := RoundScaleB6(LongHi(iy * iar)) ;
                                { quadrant symmety }
         Line(xc+ix0,yc+iy0,xc+ix1,yc+iy1) ;
         Line(xc-ix0,yc+iy0,xc-ix1,yc+iy1) ;
         Line(xc-ix0,yc-iy0,xc-ix1,yc-iy1) ;
         Line(xc+ix0,yc-iy0,xc+ix1,yc-iy1) ;
                                { ladder down }
         ix0 := ix1 ;  iy0 := iy1

      end
   end
end ;

{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }
