{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }

procedure StrokeCircle ( xc, yc : integer ; r : word ) ;

     { CircMB - Modified Bresenham circle algorithm }

var
   Color            : word ;    { default color }
   px,py            : single ;  { coordinate aspect variables }
   px2,py2          : single ;  { coordinate offset increments }
   ix,iy            : integer ; { display coordinates }
   idex,idey        : longint ; { error offset counters }
   idexx,ideyy      : longint ; { error offset increments }
   ie,iex,iey       : longint ; { error variables }

begin

   Color := GetColor ;
                                { initialize assuming 3/2 aspect }
   px := 3 * GetMaxY ;
   px2 := sqr(px) ;
   py := 2 * GetMaxX ;
   py2 := sqr(py) ;

   ix := 0 ;
   idex := Round(px2) ;
   idexx := Round(2*px2) ;
   iy := Round(r * px / py) ;
   idey := -Round((2*iy-1) * py2) ;
   ideyy := Round(2*py2) ;
   ie := 0 ;
                                { diameter points }
   PutPixel(xc,yc+iy,Color) ;
   PutPixel(xc,yc-iy,Color) ;
                               { octant points - 2,3,6,7 }
   while idex < -idey do begin

      Inc(ie,idex) ;
      Inc(idex,idexx) ;
      Inc(ix) ;
      iey := ie + idey ;
      if abs(ie) > abs(iey) then begin
         Inc(idey,ideyy) ;
         Dec(iy) ;
         ie := iey
      end ;

      PutPixel(xc+ix,yc+iy,Color) ;
      PutPixel(xc+ix,yc-iy,Color) ;
      PutPixel(xc-ix,yc+iy,Color) ;
      PutPixel(xc-ix,yc-iy,Color)

   end ;
                                { octant points - 1,4,5,8 }
   while -idey > 0 do begin

      Inc(ie,idey) ;
      Inc(idey,ideyy) ;
      Dec(iy) ;
      iex := ie + idex ;
      if abs(ie) > abs(iex) then begin
         Inc(idex,idexx) ;
         Inc(ix) ;
         ie := iex
      end ;

      PutPixel(xc+ix,yc+iy,Color) ;
      PutPixel(xc+ix,yc-iy,Color) ;
      PutPixel(xc-ix,yc+iy,Color) ;
      PutPixel(xc-ix,yc-iy,Color)

   end
end ;

{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }
