{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }

procedure StrokeCircle ( xc, yc : integer ; r : word ) ;

     { CircDAI - draw circle using difference angle method }
     {           and `increment' angle step                }

const
   isinda : longint = $169B ;
   icosda : longint = $FF00 ;

var
   ixar,iyar        : word ;    { aspect ratio parameters }
   iar              : longint ; { aspect ratio B16 }
   ida              : integer ; { loop control }
   ir               : longint ; { offset radius B6 }
   ixa0,ixa1,ixa2   : longint ; { coordinate variables B6 }
   iya0,iya1,iya2   : longint ; { coordinate variables B6 }
   ix0,iy0,ix1,iy1  : integer ; { display variables B0 }

begin
                                { constraint test }
   if r < 511 then begin
                                { aspect ratio }
      GetAspectRatio(ixar,iyar) ;
      iar := SwapLong(longint(ixar)) div longint(iyar) ;
                                { initialize differences and offset }
      ir := r shl 6 + idr ;
      ixa2 := ir * icosda ;
      ixa1 := SwapLong(ir) ;
      iya2 := -RoundScaleB16(ir * isinda) * iar ;
      iya1 := 0 ;

      ix0 := RoundScaleB6(ir) ;
      iy0 := 0 ;
      MoveTo(xc+ix0,yc) ;
                                { circle }
      for ida := 1 to 71 do begin
                                { step coordinates }
         ixa0 := (ixa1 - ixa1 div 256) shl 1 - ixa2 ;
         iya0 := (iya1 - iya1 div 256) shl 1 - iya2 ;
                                { draw chord }
         ix1 := RoundScaleB6(LongHi(ixa0)) ;
         iy1 := RoundScaleB6(LongHi(iya0)) ;
                                { semi-circular symmetry }
         LineTo(xc+ix1,yc+iy1) ;
                                { ladder down }
         ixa2 := ixa1 ;  ixa1 := ixa0 ;
         iya2 := iya1 ;  iya1 := iya0

      end ;
                                { closure }
      LineTo(xc+ix0,yc+iy0)

   end
end ;

{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }
