{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }

procedure StrokeCircle ( xc, yc : integer ; r : word ) ;

     { CircDA2 - draw circle using difference angle method }
     {           and semi-circular symmetry with floating  }
     {           point arithmetic                          }

var
   ixar,iyar        : word ;    { aspect ratio parameters }
   ar               : single ;  { aspect ratio }
   da,cosda,cosdat2 : single ;  { step angle and functions }
   ida,nda,ndad2    : integer ; { loop control }
   rc               : single ;  { offset radius }
   xa0,xa1,xa2      : single ;  { cosine generator }
   ya0,ya1,ya2      : single ;  { sine generator }
   ix0,iy0,ix1,iy1  : integer ; { display variables }

begin
                                { aspect ratio }
   GetAspectRatio(ixar,iyar) ;
   ar := ixar/iyar ;
                                { step angle and functions }
   da := 2.0 * sqrt(1.0/r) ;
   nda := Round(2.0 * Pi / da) ;
   if Odd(nda) then Inc(nda) ;
   ndad2 := nda div 2 ;
   da := 2.0 * Pi / nda ;
   cosda := cos(da) ;
   cosdat2 := 2.0 * cosda ;
                                { initialize differences and     }
                                { offset, aspect, and reflection }
   rc := r + dr ;
   xa2 := rc * cosda ;
   xa1 := rc ;
   ya2 := -rc * sin(da) * ar ;
   ya1 := 0.0 ;

   ix0 := Round(rc) ;
   iy0 := 0 ;
                                { circle }
   for ida := 1 to ndad2 do begin
                                { rotate coordinates }
      xa0 := cosdat2 * xa1 - xa2 ;
      ya0 := cosdat2 * ya1 - ya2 ;
                                { draw chord }
      ix1 := Round(xa0) ;
      iy1 := Round(ya0) ;
                                { semi-circular symmety }
      Line(xc+ix0,yc+iy0,xc+ix1,yc+iy1) ;
      Line(xc-ix0,yc-iy0,xc-ix1,yc-iy1) ;
                                { ladder down }
      xa2 := xa1 ;  xa1 := xa0 ;
      ya2 := ya1 ;  ya1 := ya0 ;
      ix0 := ix1 ;  iy0 := iy1

   end
end ;

{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }
