{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }

program BenchParabola (output) ;

     { BnchPara - compare stroke parabola and BGI parabola   }
     {            generation times                         }

uses GRAPH, DOS ;

{~~~~~~~~~~~~~~~~~~~~ parabola routine ~~~~~~~~~~~~~~~~~~~~~}

{$I conic.pas }

{-$I paramb.pas }
{$I parambr.pas }
{-$I parara.pas }
{-$I pararaf.pas }

{~~~~~~~~~~~~~~~~~~~~~ main program ~~~~~~~~~~~~~~~~~~~~~~~}

const
   nParabola = 100 ;

var
   i : integer ;
   xf,yf : integer ;
   Hour,Min,Sec,CentiSec : array[0..2] of word ;
   Time : array[0..2] of single ;
   dTimeParabola,dTimeStroke : single ;
   grDetect,grMode : integer ;

begin
   grDetect := Detect ;
   InitGraph(grDetect,grMode,'') ;
   xf := (GetMaxX + 1) shr 1 ;
   yf := (GetMaxY + 1) shr 1 ;
   Randomize ;
   GetTime(Hour[0],Min[0],Sec[0],CentiSec[0]) ;
                                { TURBO Bresenham }
{
   ClearDevice ;
   for i := 1 to nParabola do
      Parabola(xf,yf,Pi*Random) ;
}
   GetTime(Hour[1],Min[1],Sec[1],CentiSec[1]) ;
                                { stroke parabola }
   ClearDevice ;
   for i := 1 to nParabola do
      StrokeParabola(Random(GetMaxX),Random(GetMaxY),
                       Random(xf),2.0*Pi*Random) ;
   GetTime(Hour[2],Min[2],Sec[2],CentiSec[2]) ;
   CloseGraph ;
                                { convert times to seconds }
   for i := 0 to 2 do
      Time[i] := (Hour[i] * 60.0 + Min[i]) * 60.0 +
                     Sec[i] + CentiSec[i]/100.0 ;
                                { compute average drawing times }
   dTimeParabola := (Time[1] - Time[0])/nParabola ;
   dTimeStroke := (Time[2] - Time[1])/nParabola ;

   writeln (output,'Parabola: ',dTimeParabola:8:5,'   ',
                   'Stroke: ',dTimeStroke:8:5)

end.

{ Copyright (C) 1989 Adam Fritz, 133 Main St., Afton, N.Y. 13730 }
