{--------------------------------------------------------------}
{                           Tally                              }
{                                                              }
{  File size tally utility; works throughout directory trees   }
{                                                              }
{                             by Jeff Duntemann                }
{                             Turbo Pascal V5.0                }
{                             Last update 7/25/88              }
{                                                              }
{     From: COMPLETE TURBO PASCAL 5.0  by Jeff Duntemann       }
{    Scott, Foresman & Co., Inc. 1988   ISBN 0-673-38355-5     }
{--------------------------------------------------------------}

{$F+}          { To be safe, use FAR calls throughout... }
PROGRAM Tally;

USES DOS,Searcher;  { Using SEARCHER requires Version 5.0! }

VAR
  I          : Integer;
  Total      : LongInt;
  SearchSpec : String;
  InitialDirectory : String;


PROCEDURE Tallier(Foundit : SearchRec;InDirectory : String);

BEGIN
  IF InDirectory = '\' THEN
    Writeln(InDirectory,Foundit.Name)
  ELSE
    Writeln(InDirectory,'\',FoundIt.Name);
  Total := Total + Foundit.Size;
END;


BEGIN
  IF ParamCount = 0 THEN
    BEGIN
      Writeln('>>TALLY<<  V1.00  By Jeff Duntemann');
      Writeln('           From the book, COMPLETE TURBO PASCAL 5.0');
      Writeln('           Scott, Foresman & Co. 1988');
      Writeln('           ISBN 0-673-38355-5');
      Writeln;
      Writeln('This program searches for all files matching a given ');
      Writeln('filespec on the current disk device, in any subdirectory.');
      Writeln('It displays their full pathnames, and keeps a total of ');
      Writeln('the size that each occupies, so that you can determine');
      Writeln('just how much space you have tied up in .BAK files,');
      Writeln('throughout your entire disk volume.');
      Writeln;
      Writeln('CALLING SYNTAX:');
      Writeln;
      Writeln('TALLY <filespec>');
      Writeln;
      Writeln('For example, to find out how much space your screen capture');
      Writeln('files (ending in .CAP) occupy, you would enter:');
      Writeln;
      Writeln('TALLY *.CAP');
      Writeln;
    END
  ELSE
    BEGIN
      Total := 0;
      Writeln;
      SearchSpec := ParamStr(1);
      { A "naked" filespec searches the entire volume: }
      IF Pos('\',SearchSpec) = 0 THEN
        InitialDirectory := '\'
      ELSE
        BEGIN
          { This rigamarole separates the filespec from the path: }
          I := Length(SearchSpec);
          WHILE SearchSpec[I] <> '\' DO I := Pred(I);
          InitialDirectory := Copy(SearchSpec,1,I-1);
          Delete(SearchSpec,1,I);
        END;
      SearchAll(InitialDirectory,SearchSpec,0,Tallier);
      Writeln('The files listed occupy ',Total,' bytes of disk space.');
    END
END.

