{->>>>SaveScreen<<<<-------------------------------------------}
{                                                              }
{ Filename : SAVESCRN.SRC -- Last Modified 7/14/88             }
{                                                              }
{ This routine saves the current display buffer out to the     }
{ heap, regardless of how large the current display format is. }
{ The routine queries the BIOS to determine how many lines are }
{ currently on the screen, and saves only as much data to the  }
{ heap as necessary.                                           }
{                                                              }
{ Use the companion routine, RestoreScreen, to bring a screen  }
{ back from the heap.                                          }
{                                                              }
{     From: COMPLETE TURBO PASCAL 5.0  by Jeff Duntemann       }
{    Scott, Foresman & Co., Inc. 1988   ISBN 0-673-38355-5     }
{--------------------------------------------------------------}

PROCEDURE SaveScreen(VAR StashPtr : Pointer);

TYPE
  VidPtr   = ^VidSaver;
  VidSaver = RECORD
               Base,Size : Word;
               BufStart  : Byte
             END;

VAR
  VidBuffer : Pointer;
  Adapter   : AdapterType;
  StashBuf  : VidSaver;
  VidVector : VidPtr;

BEGIN
  Adapter := QueryAdapterType;
  WITH StashBuf DO
    BEGIN
      CASE Adapter OF
        MDA,EGAMono,VGAMono,MCGAMono : Base := $B000;
        ELSE Base := $B800;
      END;  { CASE }
      CASE DeterminePoints OF
        8  : CASE Adapter OF
               CGA              : Size := 4000;  { 25-line screen }
               EGAMono,EGAColor : Size := 6880;  { 43-line screen }
               ELSE               Size := 8000;  { 50-line screen }
             END; { CASE }
        14 : CASE Adapter OF
               EGAMono,EGAColor : Size := 4000;  { 25-line screen }
               ELSE               Size := 4320;  { 27-line screen }
             END; { CASE }
        16 : Size := 4000;
      END; { CASE }
      VidBuffer := Ptr(Base,0);
    END;

  GetMem(StashPtr,StashBuf.Size+4);  { Allocate heap for whole shebang }
  { Here we move *ONLY* the VidSaver record (5 bytes) to the heap: }
  Move(StashBuf,StashPtr^,Sizeof(StashBuf));
  { This casts StashPtr, a generic pointer, to a pointer to a VidSaver: }
  VidVector := StashPtr;
  { Now we move the video buffer itself to the heap.  The vide data is }
  { written starting at the BufStart byte in the VidSaver record, and  }
  { goes on for Size bytes to fit the whole buffer.  Messy but hey, this }
  { is PC land! }
  Move(VidBuffer^,VidVector^.BufStart,StashBuf.Size);
END;
