{->>>>GetLabel<<<<---------------------------------------------}
{                                                              }
{ Filename : GETLABEL.SRC -- Last Modified 7/12/88             }
{                                                              }
{ This function returns a string value that is the volume      }
{ label of the drive passed in DriveSpec.  No check is made    }
{ as to the validity of the character in DriveSpec; if there   }
{ is no corresponding drive the system may hang or return an   }
{ error depending on the specifics.  If no volume label exists }
{ for the specified volume, a null string (zero length) will   }
{ be returned and parameter LabelFound will be set to FALSE.   }
{                                                              }
{     From: COMPLETE TURBO PASCAL 5.0  by Jeff Duntemann       }
{    Scott, Foresman & Co., Inc. 1988   ISBN 0-673-38355-5     }
{--------------------------------------------------------------}


FUNCTION GetLabel(DriveSpec : String; VAR LabelFound : Boolean) : String;

TYPE
  String80 = String[80];

VAR
  I          : Integer;
  SearchSpec : String80;
  Temp       : String80;
  Regs       : Registers;
  ASCIIZ     : ARRAY[1..81] OF Char;
  DTA        : SearchRec;

BEGIN
  SearchSpec :=  DriveSpec + ':\*.*' + Chr(0);
  FindFirst(SearchSpec,$08,DTA);

  Temp := '';  { So we can return a null string if no label found }
  IF (DOSError = 2) OR (DOSError = 18) THEN     { Label not found }
    LabelFound := False
  ELSE
    BEGIN
      LabelFound := True;
      Temp := DTA.Name;
      { If a dot exists in the DTA file name, get rid of it: }
      IF Pos('.',Temp) > 0 THEN Delete(Temp,Pos('.',Temp),1);
    END;
  GetLabel := Temp;              { Assign function return value }
END;
