{->>>>GetKey<<<<-----------------------------------------------}
{                                                              }
{ Filename: GETKEY.SRC -- Last modified 7/23/88                }
{                                                              }
{ This routine uses ROM BIOS services to test for the presence }
{ of a character waiting in the keyboard buffer and, if one is }
{ waiting, return it.  The function itself returns a TRUE      }
{ if a character has been read.  The character is returned in  }
{ Ch.  If the key pressed was a "special" (non-ASCII) key, the }
{ Boolean variable Extended will be set to TRUE and the scan   }
{ code of the special key will be returned in Scan.  In        }
{ addition, GETKEY returns shift status each time it is called }
{ regardless of whether or not a character was read.  Shift    }
{ status is returned as eight flag bits in byte Shifts,        }
{ according to the bitmap below:                               }
{                                                              }
{             BITS                                             }
{     7  6  5  4  3  2  1  0                                   }
{     1  .  .  .  .  .  .  .  INSERT      (1=Active)           }
{     .  1  .  .  .  .  .  .  CAPS LOCK   (1=Active)           }
{     .  .  1  .  .  .  .  .  NUM LOCK    (1=Active)           }
{     .  .  .  1  .  .  .  .  SCROLL LOCK (1=Active)           }
{     .  .  .  .  1  .  .  .  ALT         (1=Depressed)        }
{     .  .  .  .  .  1  .  .  CTRL        (1=Depressed)        }
{     .  .  .  .  .  .  1  .  LEFT SHIFT  (1=Depressed)        }
{     .  .  .  .  .  .  .  1  RIGHT SHIFT (1=Depressed)        }
{                                                              }
{ Test for individual bits using masks and the AND operator:   }
{                                                              }
{   IF (Shifts AND $0A) = $0A THEN CtrlAndAltArePressed;       }
{                                                              }
{     From: COMPLETE TURBO PASCAL 5.0  by Jeff Duntemann       }
{    Scott, Foresman & Co., Inc. 1988   ISBN 0-673-38355-5     }
{--------------------------------------------------------------}

FUNCTION GetKey(VAR Ch       : Char;
                VAR Extended : Boolean;
                VAR Scan     : Byte;
                Var Shifts   : Byte) : Boolean;

VAR Regs  : Registers;
    Ready : Boolean;

BEGIN
  Extended := False; Scan := 0;
  Regs.AH := $01;     { AH=1: Check for keystroke }
  Intr($16,Regs);     { Interrupt $16: Keyboard services}
  Ready := (Regs.Flags AND $40) = 0;
  IF Ready THEN
    BEGIN
      Regs.AH := 0;        { Char is ready; go read it... }
      Intr($16,Regs);      { ...using AH = 0: Read Char }
      Ch := Chr(Regs.AL);  { The char is returned in AL }
      Scan := Regs.AH;     { ...and scan code in AH.    }
      IF Ch = Chr(0) THEN Extended := True ELSE Extended := False;
    END;
  Regs.AH := $02;          { AH=2: Get shift/alt/ctrl status }
  Intr($16,Regs);
  Shifts := Regs.AL;
  GetKey := Ready
END;
