{->>>>DeterminePoints<<<<--------------------------------------}
{                                                              }
{ Filename : FONTSIZE.SRC -- Last Modified 7/11/88             }
{                                                              }
{ This routine determines the character cell height for the    }
{ font currently in use.  For the MDA and EGA this is hard-    }
{ wired; for the EGA, VGA, and MCGA the value must be obtained }
{ by querying the ROM BIOS.                                    }
{                                                              }
{     From: COMPLETE TURBO PASCAL 5.0  by Jeff Duntemann       }
{    Scott, Foresman & Co., Inc. 1988   ISBN 0-673-38355-5     }
{--------------------------------------------------------------}

FUNCTION DeterminePoints : Integer;

VAR
  Regs : Registers;

BEGIN
  CASE QueryAdapterType OF
    CGA       : DeterminePoints := 8;
    MDA       : DeterminePoints := 14;
    EGAMono,        { These adapters may be using any of   }
    EGAColor,       { several different font cell heights, }
    VGAMono,        { so we need to query the BIOS to find }
    VGAColor,       { out which is currently in use. }
    MCGAMono,
    MCGAColor : BEGIN
                  WITH Regs DO
                    BEGIN
                      AH := $11;  { EGA/VGA Information Call }
                      AL := $30;
                      BL := 0;
                    END;
                  Intr($10,Regs);
                  DeterminePoints := Regs.CX
                END
  END  { CASE }
END;
