{->>>>FlushKey<<<<---------------------------------------------}
{                                                              }
{ Filename: FLUSHKEY.SRC -- Last modified 7/11/88              }
{                                                              }
{ This routine uses ROM BIOS services to flush waiting         }
{ characters from the keyboard buffer.  This should be done    }
{ immediately before user prompts which must NOT be answerable }
{ via type-ahead:  Go-aheads for file erasures, things like    }
{ that.                                                        }
{                                                              }
{     From: COMPLETE TURBO PASCAL 5.0  by Jeff Duntemann       }
{    Scott, Foresman & Co., Inc. 1988   ISBN 0-673-38355-5     }
{--------------------------------------------------------------}

PROCEDURE FlushKey;

VAR
  Regs : Registers;  { USES DOS unit! }

BEGIN
  Regs.AH := $01;            { AH=1: Check for keystroke }
  Intr($16,Regs);            { Interrupt $16: Keyboard services}
  IF (Regs.Flags AND $0040) = 0 THEN  { If chars in buffer }
    REPEAT
      Regs.AH := 0;          { Char is ready; go read it... }
      Intr($16,Regs);        { ...using AH = 0: Read Char }
      Regs.AH := $01;        { Check for another keystroke... }
      Intr($16,Regs);        { ...using AH = 1 }
    UNTIL (Regs.Flags AND $0040) <> 0;
END;
