{->>>>FlipField<<<<--------------------------------------------}
{                                                              }
{ Filename : FLIPFLD.SRC -- Last Modified 7/14/88              }
{                                                              }
{ This routine facilitates entry of "toggle" fields--fields    }
{ that have one of only two different values: Male/Female,     }
{ Citizen/Non-citizen, etc.  You specify an X,Y position for   }
{ the field, a string for each of the True and False case, and }
{ an initial Boolean value that specifies which of the two     }
{ alternatives will be initially displayed.  Pressing ESC      }
{ during entry changes nothing and sets the ESC parm to True.  }
{ Whichever state is displayed at the point the user presses   }
{ Return is the Boolean value returned in VAR parm State.      }
{                                                              }
{     From: COMPLETE TURBO PASCAL 5.0  by Jeff Duntemann       }
{    Scott, Foresman & Co., Inc. 1988   ISBN 0-673-38355-5     }
{--------------------------------------------------------------}

PROCEDURE FlipField(X,Y         : Integer;
                    VAR State   : Boolean;
                    TrueString  : String30;
                    FalseString : String30;
                    VAR Escape  : Boolean);

VAR Blanker   : String80;
    KeyStroke : 0..255;
    WorkState : Boolean;
    Ch        : Char;



PROCEDURE ShowState(NowState : Boolean);

BEGIN
  GotoXY(X,Y); Write(Blanker);   { Erase the old label }
  IF NowState THEN
    BEGIN
      GotoXY(X,Y);
      Write(TrueString)   { Write TrueString for NowState = True }
    END
  ELSE
    BEGIN
      GotoXY(X,Y);
      Write(FalseString);  { Write FalseString for NowState = False }
    END
END;


BEGIN
  Escape := False; Ch := Chr(0);
  LowVideo;                                { Use highlighting }
  FillChar(Blanker,SizeOf(Blanker),' ');   { Set up Blanker String }
  WorkState:=State;                        { Temporary Boolean }
  IF Length(TrueString)>Length(FalseString) THEN  { Adjust Blanker }
    Blanker[0] := Chr(Length(TrueString)) ELSE    {  String for lengths }
    Blanker[0] := Chr(Length(FalseString));       {  of meaning labels  }
  ShowState(WorkState);                    { Display initial label }
  REPEAT
    WHILE NOT KeyStat(Ch) DO BEGIN {NULL} END;  { Calls KeyStat... }
    KeyStroke := Ord(Ch);
    IF KeyStroke = 27 THEN Escape := True ELSE
      IF KeyStroke<>13 THEN WorkState := NOT WorkState;
    ShowState(WorkState);
  UNTIL (KeyStroke=13) OR Escape;          { ...until CR or ESC is pressed }
  IF NOT Escape THEN State:=WorkState;     { Update State if CR }
  NormVideo;
  ShowState(State);     { Redisplay State in non-highlighted text }
END;
