{--------------------------------------------------------------}
{                    PsychedelicFiberglas                      }
{                                                              }
{                             by Jeff Duntemann                }
{                             Turbo Pascal V5.0                }
{                             Last update 9/3/88               }
{                                                              }
{ This program demonstrates palette-switching through the BGI. }
{ Children of the Sixties will understand the name.            }
{                                                              }
{ From the book, COMPLETE TURBO PASCAL 5.0  by Jeff Duntemann  }
{        Scott, Foresman & Co. 1988  ISBN 0-673-38355-5        }
{--------------------------------------------------------------}

PROGRAM PsychedelicFiberglas;

USES Crt,Graph;

VAR
  I,Color     : Integer;
  Palette     : PaletteType;
  GraphDriver : Integer;
  GraphMode   : Integer;
  ErrorCode   : Integer;

BEGIN
  GraphDriver := Detect;  { Let the BGI determine what board we're using }
  DetectGraph(GraphDriver,GraphMode);
  InitGraph(GraphDriver,GraphMode,'');
  IF GraphResult <> 0 THEN
    BEGIN
      Writeln('>>Halted on graphics error: ',GraphErrorMsg(GraphResult));
      Halt(2)
    END;

  Randomize;

  GetPalette(Palette);
  FOR Color := 0 TO 10000 DO
    BEGIN
      SetColor(Random(Palette.Size));
      Line(Random(GetMaxX),Random(GetMaxY),Random(GetMaxX),Random(GetMaxY));
    END;

  REPEAT
    REPEAT I := Random(Palette.Size) UNTIL I <> 0;
    SetPalette(I,Random(Palette.Size));
  UNTIL KeyPressed;

  CloseGraph;

END.
