{->>>>DateToDayOfWeek<<<<--------------------------------------}
{                                                              }
{ Filename : DAYOWEEK.SRC -- Last Modified 7/11/88             }
{                                                              }
{ This function "calculates" the day of week from the month,   }
{ day, and year values passed to it.  The actual calculation   }
{ is done by DOS, by setting the current date in the PC to the }
{ date passed, and then reading back the current date          }
{ to get the day of week in AL.  (The real current date was    }
{ read and saved and is restored before control returns to the }
{ caller.)  The bulk of the routine deals with the fact that   }
{ DOS cannot correctly calculate the day of the week for any   }
{ leap year day.  Fortunately, it's consistent in its error,   }
{ and the error can be easily corrected for.                   }
{                                                              }
{     From: COMPLETE TURBO PASCAL 5.0  by Jeff Duntemann       }
{    Scott, Foresman & Co., Inc. 1988   ISBN 0-673-38355-5     }
{--------------------------------------------------------------}

FUNCTION DateToDayOfWeek(Year,Month,Day : Integer) : Integer;


VAR
  SaveDate,WorkDate : Registers;
  DayNumber         : Integer;
  LeapYearDay       : Boolean;

CONST
  DayArray : ARRAY[1..12] OF Integer =
    (31,28,31,30,31,30,31,31,30,31,30,31);

BEGIN
  LeapYearDay := False;
  IF (Month = 2) AND ((Year MOD 4)=0) AND (Day = 29) THEN
    LeapYearDay := True;
  IF (NOT LeapYearDay) AND (Day > DayArray[Month]) THEN
    DateToDayOfWeek := -1
    ELSE
      BEGIN
        WorkDate.AH := $2B;
        SaveDate.AH := $2A;  { Saves date encoded in registers }
        MSDOS(SaveDate);            { Fetch & save today's date }
        WITH WorkDate DO
          BEGIN
            CX := Year;      { Set the clock to the input date }
            DH := Month;
            DL := Day;
            MSDOS(WorkDate);
            AH := $2A;       { Turn around and read it back }
            MSDOS(WorkDate); {  to find the day-of-week indicator }
            DayNumber := AL; {  in AL. }
            IF LeapYearDay THEN     { Correct for DOS's leap year bug }
              IF DayNumber = 0 THEN DayNumber := 6
                ELSE DayNumber := Pred(DayNumber);
            DateToDayOfWeek := DayNumber
          END;
        SaveDate.AH := $2B;  { Restore clock to today's date }
        MSDOS(SaveDate);
      END
END;
