{--------------------------------------------------------------}
{                            Case                              }
{                                                              }
{ An upper/lower case conversion filter program for text files }
{                                                              }
{                             by Jeff Duntemann                }
{                             Turbo Pascal V5.0                }
{                             Last update 7/12/88              }
{                                                              }
{     From: COMPLETE TURBO PASCAL 5.0  by Jeff Duntemann       }
{    Scott, Foresman & Co., Inc. 1988   ISBN 0-673-38355-5     }
{--------------------------------------------------------------}


PROGRAM Caser;           { "CASE" is a reserved word... }

CONST
  Upper = True;
  Lower = False;

TYPE
  String40   = String[40];
  String80   = String[80];
  String255  = String[255];

VAR
  I,J,K     : Integer;
  Quit      : Boolean;
  Ch        : Char;
  WorkFile  : Text;
  TempFile  : Text;
  NewCase   : Boolean;
  WorkLine  : String80;
  WorkName  : String80;
  TempName  : String80;
  CaseTag   : String80;


{$I FRCECASE.SRC }     { Described in Section 15.3 }


{>>>>MakeTemp<<<<}

PROCEDURE MakeTemp(FileName : String80; VAR TempName : String80);

VAR
  Point : Integer;

BEGIN
  Point := Pos('.',FileName);
  IF Point > 0 THEN Delete(FileName,Point,(Length(FileName)-Point)+1);
  TempName := Concat(FileName,'.$$$')
END;


{ CASER MAIN }

BEGIN
  Quit := False;
  IF ParamCount < 2 THEN    { Missing parms error }
    BEGIN
      Writeln('>>CASE<<  V2.00  By Jeff Duntemann');
      Writeln('          From the book, COMPLETE TURBO PASCAL 5.0');
      Writeln('          Scott, Foresman & Co. 1988');
      Writeln('          ISBN 0-673-38355-5');
      Writeln;
      Writeln('This program forces all characters of a text file to either ');
      Writeln('upper or lower case, as requested.  Characters already in ');
      Writeln('the requested case are not disturbed.');
      Writeln;
      Writeln('CALLING SYNTAX:');
      Writeln;
      Writeln('CASE UP|DOWN <filespec>');
      Writeln;
      Writeln('For example, to force all lowercase characters of file');
      Writeln('FOO.COB to uppercase, invoke CASE this way:');
      Writeln;
      Writeln('CASE UP FOO.COB');
      Writeln;
    END
  ELSE
    BEGIN
      WorkName := ParamStr(2);
      Assign(WorkFile,WorkName);  { Attempt to open the file }
      {$I-} Reset(WorkFile); {$I+}
      IF IOResult <>0 THEN
        BEGIN
          Writeln('<<Error!>> File ',WorkName,' does not exist.');
          Writeln('           Invoke CASE again with an existing FileName.');
          END
      ELSE
        BEGIN                 { See if UP/DOWN parm was entered }
          CaseTag := ParamStr(1);
          CaseTag := ForceCase(Upper,CaseTag);
          IF CaseTag = 'UP' THEN NewCase := Upper ELSE
            IF CaseTag = 'DOWN' THEN NewCase := Lower ELSE
              Quit := True;
          IF Quit THEN
            BEGIN
              Writeln
              ('<<Error!>> The case parameter must be "UP" or "DOWN."');
              Writeln
              ('           Invoke CASE again using either "UP" or "DOWN".');
            END
          ELSE
            BEGIN
              Write('Forcing case ');
              IF NewCase THEN Write('up ') ELSE Write('down ');
              MakeTemp(WorkName,TempName);  { Generate temporary FileName }
              Assign(TempFile,TempName);    { Open temporary file }
              Rewrite(TempFile);
              WHILE NOT EOF(WorkFile) DO
                BEGIN
                  Readln(WorkFile,WorkLine);
                  Write('.');               { Dot shows it's working }
                  WorkLine := ForceCase(NewCase,WorkLine);
                  Writeln(TempFile,WorkLine)
                END;
              Close(TempFile);              { Close the temporary file }
              Close(WorkFile);              { Close original source file... }
              Erase(WorkFile);              { ...and delete it. }
              Rename(TempFile,WorkName);    { Temporary file becomes source }
            END
       END
    END
END.
