{->>>>DIRToString<<<<------------------------------------------}
{                                                              }
{ Filename : DIRSTRIN.SRC -- Last Modified 6/9/88              }
{                                                              }
{ This routine returns a String value containing all the       }
{ significant information from a directory record, formatted   }
{ in a fashion similar to that used by the DOS DIR command     }
{ when it displays a file and its information.  A typical      }
{ string returned by DIRToString would look like this:         }
{                                                              }
{       DIRSTRIN.BAK 1697  01/07/87   3:04p                    }
{                                                              }
{ Type DIRRec must be predefined.                              }
{                                                              }
{     From: COMPLETE TURBO PASCAL 5.0  by Jeff Duntemann       }
{    Scott, Foresman & Co., Inc. 1988   ISBN 0-673-38355-5     }
{--------------------------------------------------------------}

FUNCTION DIRToString(InputDIR : DIRRec) : String;

CONST
  Blanker = '                                              ';

VAR
  Temp,WorkString : String80;
  DotPos : Integer;

BEGIN
  WITH InputDIR DO
    BEGIN
      Temp := '                                        ';
      {If the entry has the directory attribute, format differently: }
      IF (Attrib AND $10) <> 0 THEN    { Bit 4 is the directory attribute }
        BEGIN
          Insert(FileName,Temp,1);  { No extensions on subdirectory names }
          Insert('<DIR>',Temp,14)   { Tell the world it's a subdirectory  }
        END
      ELSE
        {This compound statement separates the file from its extension  }
        { and converts the file size to a string.  Note that we did not }
        { insert a file size figure into Temp for subdirectory entries. }
        BEGIN
          DotPos := Pos('.',FileName);
          IF DotPos > 0 THEN  { File name has an extension }
            WorkString := Copy(FileName,1,DotPos-1) +
              Copy(Blanker,1,9-DotPos) + '.' +
              Copy(FileName,DotPos+1,Length(FileName)-DotPos)
          ELSE
            WorkString := FileName + Copy(Blanker,1,8-Length(FileName)) + '.';
          Insert(WorkString,Temp,1);
          Str(FileSize:7,WorkString);
          Insert(WorkString,Temp,15)
        END;
      WITH DateStamp DO
        BEGIN
          { This is what it takes to assemble three separate integer  }
          { figures for month, day, and year into a string equivalent.}
          IF Month < 10 THEN Insert('0',DateString,1);
          IF Day < 10 THEN Insert('0',DateString,4);
          Insert(DateString,Temp,24);
        END;
      Insert(TimeStamp.TimeString,Temp,34); { Finally, insert the time }
    END;
  Delete(Temp,42,Length(Temp)-42);
  DIRToString := Temp
END;
