{->>>>CalcTime<<<<---------------------------------------------}
{                                                              }
{ Filename: CALCTIME.SRC -- Last Modified 7/7/88               }
{                                                              }
{ This routine "fills out" a TimeRec passed to it with only    }
{ the DOS time values (hours, minutes, seconds, hundredths)    }
{ valid.  It generates the TimeComp and TimeString fields.     }
{                                                              }
{     TimeRec = RECORD                                         }
{                 TimeComp   : Word;      (DTA time stamp)     }
{                 TimeString : String80;                       }
{                 Hours,Minutes,Seconds,Hundredths : Integer   }
{               END;                                           }
{                                                              }
{ which, of course, also requires definition of type String80. }
{                                                              }
{     From: COMPLETE TURBO PASCAL 5.0  by Jeff Duntemann       }
{    Scott, Foresman & Co., Inc. 1988   ISBN 0-673-38355-5     }
{--------------------------------------------------------------}

PROCEDURE CalcTime(VAR ThisTime : TimeRec);

TYPE
  String5 = String[5];

VAR
  Temp1,Temp2 : String5;
  AMPM        : Char;
  I           : Integer;

BEGIN
  WITH ThisTime DO
    BEGIN
      I := Hours;
      IF Hours = 0 THEN I := 12;   { "0" hours = 12am }
      IF Hours > 12 THEN I := Hours - 12;
      IF Hours > 11 THEN AMPM := 'p' ELSE AMPM := 'a';
      Str(I:2,Temp1); Str(Minutes,Temp2);
      IF Length(Temp2) < 2 THEN Temp2 := '0' + Temp2;
      TimeString := Temp1 + ':' + Temp2 + AMPM;
      TimeComp :=
        (Hours SHL 11) OR (Minutes SHL 5) OR (Seconds SHR 1)
    END
END;
