{--------------------------------------------------------------}
{                            TOUCHER                           }
{                                                              }
{          'Touch' utility for DOS unit demonstration          }
{                                                              }
{                             by Jeff Duntemann                }
{                             Turbo Pascal V4.0                }
{                             Last update 7/1/88               }
{                                                              }
{ From the book, COMPLETE TURBO PASCAL 5.0  by Jeff Duntemann  }
{        Scott, Foresman & Co. 1988  ISBN 0-673-38355-5        }
{--------------------------------------------------------------}


PROGRAM Toucher;

USES DOS;

VAR
  I      : Integer;
  Stamp  : LongInt;
  Now    : DateTime;
  Target : File;
  Sec100 : Word;
  DayOfWeek  : Word;

BEGIN
  IF ParamCount < 1 THEN
    BEGIN
       Writeln('>>TOUCHER  V1.00 by Jeff Duntemann');
       Writeln('           From the book COMPLETE TURBO PASCAL 5.0');
       Writeln('           Scott, Foresman & Company, 1988');
       Writeln('           ISBN 0-673-38355-5');
       Writeln;
       Writeln('  Calling Syntax:');
       Writeln('  TOUCHER <filename>');
       Writeln;
       Writeln('  TOUCHER is a "touch" utility that replaces ');
       Writeln('  the time/date stamp of a file with the current');
       Writeln('  date and time.  This can be used to force a remake');
       Writeln('  on a project depending on that file.');
    END
  ELSE
    BEGIN
      Assign(Target,ParamStr(1));
      {$I-} Reset(Target); {$I+}
      I := IOResult;
      IF I <> 0 THEN
        BEGIN
          Writeln('>>Error!  Named file cannot be opened...');
        END
      ELSE
        BEGIN
          WITH Now DO GetTime(Hour,Min,Sec,Sec100);
          WITH Now DO GetDate(Year,Month,Day,DayOfWeek);
          PackTime(Now,Stamp);
          SetFTime(Target,Stamp);
          Close(Target);
        END
    END
END.
