{--------------------------------------------------------------}
{                           SPACER                             }
{                                                              }
{             Directory lister with file size tally            }
{                                                              }
{                             by Jeff Duntemann                }
{                             Turbo Pascal 5.00                }
{                             Last update 7/2/88               }
{                                                              }
{  This utility functions similarly to DOS DIR in that it      }
{  displays a directory of files in a subdirectory, but unlike }
{  DIR it keeps a running total of the size of the files       }
{  displayed.  It exists mostly to demonstrate the generation  }
{  of a linked list of directory entries through the procedure }
{  GetDirectory.  Ideally, it should be expanded into a        }
{  utility similar to SWEEP.                                   }
{                                                              }
{     From: COMPLETE TURBO PASCAL 5.0  by Jeff Duntemann       }
{    Scott, Foresman & Co., Inc. 1988   ISBN 0-673-38355-5     }
{--------------------------------------------------------------}

PROGRAM Spacer;

USES DOS;

CONST
  SortByName = True;
  SortByDate = False;

TYPE
 String80 = String[80];
 String15 = String[15];
 DTAPtr   = ^SearchRec;

{$I TIMEREC.DEF}     { Described in Section 20.6 }
{$I DATEREC.DEF}     { Described in Section 20.6 }
{$I DIRREC.DEF}      { Described in Section 20.7 }


VAR
  Parms      : Byte;
  SpaceTaken : Real;
  RunUp      : DIRPtr;
  RunDown    : DIRPtr;
  Current    : DIRPtr;
  FileSpec   : String80;
  WorkString : String80;
  Sorted     : Boolean;
  SortSpec   : Boolean;
  Ascending  : Boolean;
  I          : Integer;


{$I DAYOWEEK.SRC}    { Described in Section 20.6 }
{$I CALCDATE.SRC}    { Described in Section 20.6 }
{$I CALCTIME.SRC}    { Described in Section 20.6 }
{$I DTATODIR.SRC}    { Described in Section 20.7 }
{$I GETDIR.SRC}      { Described in Section 21.4 }
{$I DIRSTRIN.SRC}    { Described in Section 20.7 }



BEGIN
  Sorted := False;           { Set default values }
  SortSpec := SortByName;
  Ascending := True;
  Parms := ORD(ParamCount);  { Convert parm count to ordinal value }
  CASE Parms OF
    0 :
    BEGIN
      Writeln('>>SPACER<<  V2.00  By Jeff Duntemann');
      Writeln('            From the book, COMPLETE TURBO PASCAL 5.0');
      Writeln('            Scott, Foresman & Co. 1988');
      Writeln('            ISBN 0-673-38355-5');
      Writeln;
      Writeln('This program displays ALL files matching a given filespec.');
      Writeln('Hidden and system files are not immune.');
      Writeln('Additionally, it will add up the cumulative file sizes of');
      Writeln('the files matching the filespec, so you can tell how much');
      Writeln('space files in a given subdirectory subtend, or how much');
      Writeln('space you have invested in .PAS files, and so on.');
      Writeln;
      Writeln('CALLING SYNTAX:');
      Writeln;
      Writeln('SPACER <filespec> N|D A|D');
      Writeln;
      Writeln('where <filespec> is a legal DOS filespec, including wildcards.');
      Writeln('The second parameter is either N or D:');
      Writeln('N indicates sort by file name;');
      Writeln('D indicates sort by time and date stamp.');
      Writeln('If not given, entries are displayed in physical order.');
      Writeln;
      Writeln('The third parameter is either A or D:');
      Writeln('A indicates ascending order of display;');
      Writeln('D indicates descending order of display.');
      Writeln('If not given, sort is ascending.');
      Writeln;
      Writeln('For example:');
      Writeln;
      Writeln('SPACER *.PAS N');
      Writeln('  will display all files with the .PAS extension,');
      Writeln('  in ascending sorted order by file name.  Or,');
      Writeln;
      Writeln('SPACER *.PAS D D');
      Writeln('  will display all files with the .PAS extension,');
      Writeln('  in descending order by last-modification date.');
      Halt;
    END;
    1 : FileSpec := ParamStr(1);
    2 : BEGIN
          Sorted := True;
          FileSpec := ParamStr(1);
          WorkString := ParamStr(2);
          CASE UpCase(WorkString[1]) OF
            'D' : SortSpec := SortByDate;
            'N' : SortSpec := SortByName;
            ELSE Sorted := False
          END
        END;
    3 : BEGIN
          Sorted := True;
          FileSpec := ParamStr(1);
          WorkString := ParamStr(2);
          CASE UpCase(WorkString[1]) OF
            'D' : SortSpec := SortByDate;
            'N' : SortSpec := SortByName;
            ELSE Sorted := False
          END;
          IF Sorted THEN
            BEGIN
              WorkString := ParamStr(3);
              CASE UpCase(WorkString[1]) OF
                'A' : Ascending := True;
                'D' : Ascending := False;
                ELSE Ascending := True
              END
            END
        END;
   END; { CASE }
   { Now we actually go out and build a linked list of directory entries, }
   { based on the parms we have parsed out of the command line: }
   GetDirectory(FileSpec,Sorted,SortSpec,RunUp,RunDown);
   IF Ascending THEN Current := RunUp
     ELSE Current := RunDown;
   IF Current = Nil THEN Writeln('No files found.')
     ELSE
       BEGIN
         SpaceTaken := 0.0;
         IF Ascending THEN
           WHILE Current <> NIL DO
             BEGIN
               Writeln(DirToString(Current^));
               SpaceTaken := SpaceTaken + Current^.FileSize;
               Current := Current^.Next
             END
         ELSE
           WHILE Current <> NIL DO
             BEGIN
               Writeln(DirToString(Current^));
               SpaceTaken := SpaceTaken + Current^.FileSize;
               Current := Current^.Prior
             END;
         Writeln;
         Writeln
         ('Total space occupied by these files is ',SpaceTaken:9:0,' bytes.');
       END
END.
