{--------------------------------------------------------------}
{                          ShowName                            }
{                                                              }
{           Keyed file binary search demo program              }
{                                                              }
{                             by Jeff Duntemann                }
{                             Turbo Pascal V5.0                }
{                             Last update 7/24/88              }
{                                                              }
{     From: COMPLETE TURBO PASCAL 5.0  by Jeff Duntemann       }
{    Scott, Foresman & Co., Inc. 1988   ISBN 0-673-38355-5     }
{--------------------------------------------------------------}

{ Unlike most programs in this book, this program requires two }
{ external files to operate: FRIENDS.NAP and FRIENDS.KEY.  The }
{ two files will be included on the source listings diskette.  }
{ FRIENDS.NAP is a file of NAPRec containing some number of    }
{ name/address/phone records.  FRIENDS.KEY is a sorted key     }
{ file containing keys extracted from FRIENDS.NAP.  You can    }
{ write a utility to extract keys from a .NAP file and sort    }
{ them using either the SHELLSORT or QUIKSORT procedures given }
{ in Section 14. }

PROGRAM ShowName;

TYPE
  String3     = String[3];
  String6     = String[6];
  String30    = String[30];
  String40    = String[40];
  String80    = String[80];
  String255   = String[255];

  NAPRec = RECORD
             Name    : String30;
             Address : String30;
             City    : String30;
             State   : String3;
             Zip     : String6
           END;

  NAPFile = FILE OF NAPRec;

  KeyRec  = RECORD
              REF : Integer;
              KeyData : String30
            END;

  KeyFile = FILE OF KeyRec;


VAR I,J,K     : Integer;
    RecNum    : Integer;
    Parm      : String80;
    WorkRec   : NAPRec;
    WorkFile  : NAPFile;
    WorkKey   : KeyFile;


{$I KSEARCH.SRC}   { Contains KeySearch }


{ SHOWNAME MAIN }

BEGIN
  IF ParamCount < 1 THEN            { Missing parms error }
    BEGIN
      Writeln('<<Error!>> You must enter a name on the command line:');
      Writeln('           A>SHOWNAME Duntemann*Jeff ')
    END
  ELSE
    BEGIN
      Parm := ParamStr(1);
      Assign(WorkFile,'FRIENDS.NAP');  { Open the names data file }
      Reset(WorkFile);
      Assign(WorkKey,'FRIENDS.KEY');   { Open the names key file }
      Reset(WorkKey);
      IF KeySearch(WorkKey,RecNum,Parm) THEN  { If key is found...}
        BEGIN                          { We have record # into data file }
          Seek(WorkFile,RecNum);       { Seek to record # in data file }
          Read(WorkFile,WorkRec);      { Read data record from data file }
          WITH WorkRec DO              { and display the name/address data }
            BEGIN
              Writeln('>>NAME    : ',Name);
              Writeln('  ADDRESS : ',Address);
              Writeln('  CITY    : ',City);
              Writeln('  STATE   : ',Zip);
            END
        END
      ELSE
        Writeln('>>Sorry, ',Parm,' not found.');
    END
END.
