{->>>>ShellSort<<<<--------------------------------------------}
{                                                              }
{ Filename : SHELSORT.SRC -- Last Modified 7/14/88             }
{                                                              }
{ This is your textbook Shell sort on an array of key records, }
{ defined as the type show below:                              }
{                                                              }
{     KeyRec = RECORD                                          }
{                Ref     : Integer;                            }
{                KeyData : String30                            }
{              END;                                            }
{                                                              }
{     From: COMPLETE TURBO PASCAL 5.0  by Jeff Duntemann       }
{    Scott, Foresman & Co., Inc. 1988   ISBN 0-673-38355-5     }
{--------------------------------------------------------------}

PROCEDURE ShellSort(VAR SortBuf : KeyArray; Recs : Integer);

VAR
  I,J,K,L : Integer;
  Spread  : Integer;


PROCEDURE KeySwap(VAR RR,SS : KeyRec);

VAR
  T : KeyRec;

BEGIN
  T := RR;
  RR := SS;
  SS := T
END;


BEGIN
  Spread := Recs DIV 2;       { First Spread is half record count  }
  WHILE Spread > 0 DO         { Do until Spread goes to zero:      }
    BEGIN
      FOR I := Spread + 1 TO Recs DO
        BEGIN
          J := I - Spread;
          WHILE J > 0 DO
            BEGIN             { Test & swap across the array }
              L := J + Spread;
              IF SortBuf[J].KeyData <= SortBuf[L].KeyData THEN J := 0 ELSE
                KeySwap(SortBuf[J],SortBuf[L]);
              J := J - Spread
            END
        END;
      Spread := Spread DIV 2    { Halve Spread for next pass }
    END
END;
