{--------------------------------------------------------------}
{                           AspectRatio                        }
{                                                              }
{         Aspect ratio adjustment demonstration program        }
{                                                              }
{                             by Jeff Duntemann                }
{                             Turbo Pascal V5.0                }
{                             Last update 9/3/88               }
{                                                              }
{     From: COMPLETE TURBO PASCAL 5.0  by Jeff Duntemann       }
{    Scott, Foresman & Co., Inc. 1988   ISBN 0-673-38355-5     }
{--------------------------------------------------------------}

PROGRAM AspectRatio;

USES Crt,Graph;

VAR
  I,Color     : Integer;
  Palette     : PaletteType;
  GraphDriver : Integer;
  GraphMode   : Integer;
  ErrorCode   : Integer;


{$I SQUARE.SRC}      { Described in Section 22.3 }


PROCEDURE AdjustAspectRatio;

VAR Side   : Integer;
    W      : Word;
    Ch     : Char;
    Quit   : Boolean;
    Delta  : Integer;
    Color  : Word;
    Filler : FillSettingsType;
    TheLine         : String;
    XAspect,YAspect : Word;


PROCEDURE ShowRatio;

VAR
  Temp : String;

BEGIN
  SetFillStyle(0,0); Bar(0,0,GetMaxX,20);
  WITH Filler DO SetFillStyle(Pattern,Color);
  GetAspectRatio(XAspect,YAspect);
  TheLine := 'Current ratio: ';
  Str(XAspect:6,Temp);
  TheLine := TheLine + Temp + '/';
  Str(YAspect:6,Temp);
  TheLine := TheLine + Temp + '  Arrows to adjust; Q quits...';
  OutTextXY(10,10,TheLine)
END;


BEGIN
  Quit := False; Side := 180;
  Color := GetColor; GetFillSettings(Filler);
  GetAspectRatio(XAspect,YAspect);
  Delta := YAspect DIV 100;
  Square((GetMaxX DIV 2)-(Side DIV 2),
         (GetMaxY DIV 2)-(Side DIV 2),Side,True);

  ShowRatio;
  REPEAT
    Ch := ReadKey;
    IF Ch <> #0 THEN
      IF Ch in ['Q','q'] THEN Quit := True ELSE Quit := False
    ELSE
      BEGIN
        Ch := ReadKey;
        CASE Ord(Ch) OF
          $48 : BEGIN
                 SetColor(0);
                 Square((GetMaxX DIV 2)-(Side DIV 2),
                        (GetMaxY DIV 2)-(Side DIV 2),Side,True);
                 {Kluge fix:} W := YAspect+Delta;
                 SetAspectRatio(XAspect,W);
                 SetColor(Color);
                 Square((GetMaxX DIV 2)-(Side DIV 2),
                        (GetMaxY DIV 2)-(Side DIV 2),Side,True);
                 ShowRatio;
               END;
          $50 : BEGIN
                 SetColor(0);
                 Square((GetMaxX DIV 2)-(Side DIV 2),
                        (GetMaxY DIV 2)-(Side DIV 2),Side,True);
                 {Kluge fix:} W := YAspect-Delta;
                 SetAspectRatio(XAspect,W);
                 SetColor(Color);
                 Square((GetMaxX DIV 2)-(Side DIV 2),
                        (GetMaxY DIV 2)-(Side DIV 2),Side,True);
                 ShowRatio;
               END;
        END; { CASE }
      END
  UNTIL Quit
END;


BEGIN
  GraphDriver := Detect;  { Let the BGI determine what board we're using }
  DetectGraph(GraphDriver,GraphMode);
  InitGraph(GraphDriver,GraphMode,'');
  IF GraphResult <> 0 THEN
    BEGIN
      Writeln('>>Halted on graphics error: ',GraphErrorMsg(GraphResult));
      Halt(2)
    END;

  AdjustAspectRatio;

  CloseGraph;
END.
