{--------------------------------------------------------------}
{                          Patterns                            }
{                                                              }
{            Graphics pattern demonstration program            }
{                                                              }
{                             by Jeff Duntemann                }
{                             Turbo Pascal V5.0                }
{                             Last update 9/3/88               }
{                                                              }
{     From: COMPLETE TURBO PASCAL 5.0  by Jeff Duntemann       }
{    Scott, Foresman & Co., Inc. 1988   ISBN 0-673-38355-5     }
{--------------------------------------------------------------}

PROGRAM Patterns;

USES Graph;

CONST
  Halftone1 : FillPatternType =
              ($CC,$33,$CC,$33,$CC,$33,$CC,$33);
  Halftone2 : FillPatternType =
              ($AA,$55,$AA,$55,$AA,$55,$AA,$55);
  Squiggles : FillPatternType =
              ($94,$84,$48,$30,$00,$c1,$22,$14);
  Vertical  : FillPatternType =
              ($CC,$CC,$CC,$CC,$CC,$CC,$CC,$CC);
  Bricks    : FillPatternType =
              ($01,$82,$44,$28,$10,$20,$40,$80);
  Blocks    : FillPatternType =
              ($00,$3C,$42,$42,$42,$42,$3C,$00);

VAR
  GraphDriver : Integer;
  GraphMode   : Integer;
  ErrorCode   : Integer;


BEGIN
  GraphDriver := Detect;  { Let the BGI determine what board we're using }
  DetectGraph(GraphDriver,GraphMode);
  InitGraph(GraphDriver,GraphMode,'');
  IF GraphResult <> 0 THEN
    BEGIN
      Writeln('>>Halted on graphics error: ',GraphErrorMsg(GraphResult));
      Halt(2)
    END;


  SetFillPattern(Halftone1,White);
  Bar(0,0,99,100);
  Rectangle(0,0,99,100);

  SetFillPattern(Halftone2,White);
  Bar(110,0,209,100);
  Rectangle(110,0,209,100);

  SetFillPattern(Squiggles,White);
  Bar(220,0,319,100);
  Rectangle(220,0,319,100);

  SetFillPattern(Vertical,White);
  Bar(0,105,99,199);
  Rectangle(0,105,99,199);

  SetFillPattern(Bricks,White);
  Bar(110,105,209,199);
  Rectangle(110,105,209,199);

  SetFillPattern(Blocks,White);
  Bar(220,105,319,199);
  Rectangle(220,105,319,199);

  Readln;
  CloseGraph;
END.
