PROGRAM Generic;


LABEL
  100;

CONST
  Iterations = 25;

TYPE
  InputFile  = TEXT;
  String80   = String[80];

VAR
  Counter    : Integer;
  OK         : Boolean;
  LIMIT      : Integer;
  FooFactor  : Integer;
  Buffer     : String80;
  DoFile     : InputFile;


PROCEDURE OpenAFile(VAR OK : Boolean);

VAR
  I : Integer;

BEGIN
  Assign(DoFile,'MYTEXT.TXT');
  {$I-} Reset(DoFile); {$I+}
  I := IOResult;
  IF I = 0 THEN OK := True ELSE OK := False;
END;


FUNCTION CrunchLine(Buffer : String80) : Integer;

VAR
  I      : Integer;
  Bucket : Integer;

BEGIN
  CrunchLine := 0;
  IF Length(Buffer) > 0 THEN
    BEGIN
      Bucket := 0;
      FOR I := 1 TO Length(Buffer) DO Bucket := Bucket +
        Ord(Buffer[I]);
      Bucket := Bucket DIV LENGTH(Buffer);
      CrunchLine := Bucket
    END
END;


FUNCTION CrunchFile(VAR DoFile : InputFile) : Integer;

VAR
  Passes : Integer;
  Temp   : Integer;

BEGIN
  Temp := 0;
  FOR Passes := 1 TO Iterations DO
    BEGIN
      Reset(DoFile);
      WHILE NOT EOF(DoFile) DO
        BEGIN
          Readln(DoFile,Buffer);
          Temp := Temp+CrunchLine(Buffer);
        END
    END;
  CrunchFile := Temp DIV Iterations
END;



BEGIN     { Main Program }
  OpenAFile(OK);
  IF NOT OK THEN
    BEGIN
      Writeln('>>The file cannot be opened.');
      GOTO 100
    END;
  FooFactor := CrunchFile(DoFile);
  Writeln('>>Foo Factor for Input File is ',FooFactor);
  Close(DoFile);
  Writeln('>>Processing completed.');
  100:
END.
