;===========================================================================
;
;    C L E A R S  -  Screen clear primitive for Turbo Pascal
;
;===========================================================================
;
;     by Jeff Duntemann      12 February 1988
;
;     From: COMPLETE TURBO PASCAL 5.0  by Jeff Duntemann
;    Scott, Foresman & Co., Inc. 1988   ISBN 0-673-38355-5
;
; CLEARS is written to be called from Turbo Pascal V4.0 using the
; {$L}/EXTERNAL procedure convention.  It has the advantage over ClrScr in
; that it can clear a screen stored on the heap, and also that a screen can
; be cleared with a character other than space, like the IBM PC's halftone
; characters, for the Framework effect.  An attribute can be written to the
; cleared buffer as well as a clear character.
;
; To use CLEARS on the visible screen, you must "doctor" a declared
; pointer to point to either the monochrome or graphics text buffer:
;
; VAR
;   VisibleScreen : Pointer;
;
; VisibleScreen := Ptr($B000,0);  { For the monochrome adapter }
; VisibleScreen := Ptr($B800,0);  { For the color graphics adapter }
;
; Declare the procedure itself as external using this declaration:
;
; {$L CLEARS}
; PROCEDURE CLEARS(Target    : Pointer; ScreenSize : Integer;
;                  Attribute : Integer; CharFill   : Byte);
;                  EXTERNAL;
;
;
; Pass CLEARS the attribute code you wish to use in Attribute
; (typically $0700 for "normal" text display) and the character to "clear"
; with in CharFill.  Use 32 or Ord(' ') to fill with blanks, or you may use
; the "halftone" characters (176-178) for Framework style screens.  Keep
; in mind that the attribute code must be in the HIGH byte of the actual
; parameter passed to Attribute.
;
; EXAMPLES:
;
; To clear the visible screen to normal blanks:
;    CLEARS(VisibleScreen,4096,$0700,' ');
;
; To clear a screen on the heap to a halftone screen:
;    CLEARS(NewScreen,4096,$0700,176);
;
; Obviously, you must have declared VisibleScreen and NewScreen and set
; them up so that they both point to either a screen on the heap or the
; visible screen buffer.  If the pointer Target has a value of NIL,
; CLEARS will return to the calling logic without taking any action.
; Good thing, too--if it did, it would blank your interrupt vector table!
;
;
; To reassemble/relink CLEARS:
;-------------------------------------
; Assemble this file with MASM.  "A> MASM CLEARS;"

CODE    SEGMENT BYTE PUBLIC
        ASSUME  CS:CODE
        PUBLIC  CLEARS
;
; This structure maps the stack at entry to CLEARS:
;
ONSTACK STRUC
OLDBP   DW ?    ;CALLER'S BP VALUE SAVED ON STACK
RETADDR DW ?    ;NEAR RETURN ADDRESS
FILLER  DW ?    ;CHARACTER THAT FILLS THE CLEARED BUFFER
ATTRIB  DW ?    ;ATTRIBUTE FOR THE CLEARED BUFFER
BUFSIZE DW ?    ;SIZE OF THE BUFFER TO BE CLEARED, IN BYTES
BUFOFS  DW ?    ;OFFSET OF BUFFER ORIGIN
BUFSEG  DW ?    ;SEGMENT OF BUFFER ORIGIN
ENDMRK  DB ?    ;DUMMY LABEL TO MARK END OF DATA ON STACK
ONSTACK ENDS
;


CLEARS  PROC    NEAR
        PUSH    BP
        MOV     BP,SP                   ; CALLING CONVENTION
;
;----------------------------------------------------
; FIRST WE TEST FOR BUFFER = NIL...QUIT IF SO
;----------------------------------------------------
;
        CMP     WORD PTR [BP].BUFSEG,0  ; A NIL POINTER IS A SEGMENT AND
        JNE     START                   ; OFFSET BOTH SET TO 0
        CMP     WORD PTR [BP].BUFOFS,0
        JE      BYE

;
;----------------------------------------------------
; PREPARE THE REGISTERS FOR THE STORE WORD OPERATION
;----------------------------------------------------
;
START:  CLD                             ; CLEAR DIRECTION FLAG
        MOV     AX,[BP].ATTRIB          ; LOAD ATTRIBUTE CODE INTO AX
        AND     AX,0FF00H               ; MASK OUT LOW BYTE OF ATTRIBUTE CODE
        MOV     BX,[BP].FILLER          ; LOAD FILLER CODE INTO BX
        AND     BX,0FFH                 ; MASK OUT HIGH BYTE OF FILLER CODE
        OR      AX,BX                   ; AND COMBINE ATTRIB & FILLER INTO AX
        MOV     DI,[BP].BUFOFS          ; SET DI TO TARGET BUFFER OFFSET
        MOV     ES,[BP].BUFSEG          ; SET ES TO TARGET BUFFER SEGMENT
;
;---------------------------------------------------------------
; LOOP TO STORE CHARACTER AND ATTRIBUTE INTO BUFFER BY WORD MOVE
;---------------------------------------------------------------
;
        MOV     CX,[BP].BUFSIZE         ; SET UP COUNTER WITH BUFFER SIZE
        REP     STOSW                   ; DO THE STRING STORE
;
;------------------------------------
; DONE.. CLEAN UP THE STACK AND LEAVE
;------------------------------------
;
BYE:    MOV     SP,BP                   ; RESTORE PRIOR STACK POINTER & BP
        POP     BP                      ;  IN CONVENTIONAL RETURN
        RET     ENDMRK-RETADDR-2        ; TRASH 10 BYTES FOR PARMS

CLEARS  ENDP
CODE    ENDS
        END
