;===========================================================================
;
;    B U T T O N  -  Function to return the state of the joystick buttons
;
;===========================================================================
;
;     by Jeff Duntemann      12 February 1988
;
;     From: COMPLETE TURBO PASCAL 5.0  by Jeff Duntemann
;    Scott, Foresman & Co., Inc. 1988   ISBN 0-673-38355-5
;
; BUTTON is written to be called from Turbo Pascal V4.0 using the
; {$L}/EXTERNAL procedure convention.
;
; Declare the procedure itself as external using this declaration:
;
; {$L BUTTON}
; FUNCTION BUTTON(StickNumber,ButtonNumber : Integer) : Boolean;
;                                                       EXTERNAL;
;
; StickNumber specifies which joystick to read from, and ButtonNumber
; specifies which of the two buttons on that joystick to read.  If the
; specified button is down, BUTTON returns a Boolean value of TRUE.
;
; Yes, this is the long way 'round; assembly language is in no way required
; to read four bits from an ordinary 8088 I/O port.  BUTTON exists only as
; practice in creating assembly language external functions.
;
; The button information is obtained by reading I/O port $201.  The high
; four bits represent the state of the four buttons (two for each of the
; two possible joysticks) at the instant the port is read.  A LOW bit
; represents a button DOWN.  This is why the byte read from the port is
; inverted via NOT before the selected bit is tested.
;
; Here is a map of the button bits as returned by port $201:
;
;     |7 6 5 4 3 2 1 0|
;      | | | |
;      | | |  - - - - - - -> Button #1, joystick #1
;      | |  - - - - - - - -> Button #2, joystick #1
;      |  - - - - - - - - -> Button #1, joystick #2
;       - - - - - - - - - -> Button #2, joystick #2
;
; Remember that the return value from this function is passed to the runtime
; code in the AL register.
;
; To reassemble/relink BUTTON:
;-------------------------------------
; Assemble this file with MASM.  "C>MASM BUTTON;"
;
;
; This structure defines the layout of parameters on the stack:
;

ONSTACK   STRUC
OLDBP     DW   ?               ;TOP OF STACK
RETADDR   DD   ?               ;FAR RETURN ADDRESS
BTN_NO    DW   ?               ;BUTTON NUMBER
STIK_NO   DW   ?               ;STICK NUMBER
ONSTACK   ENDS

CODE    SEGMENT BYTE PUBLIC
        ASSUME  CS:CODE
        PUBLIC  BUTTON

BUTTON  PROC    FAR
        PUSH    BP              ;SAVE PREVIOUS VALUE OF BP ON STACK
        MOV     BP,SP           ;SP BECOMES NEW VALUE OF BP

;-------------------------------------------------------------------
; THE BULK OF THIS ROUTINE SETS UP A TEST MASK BY WHICH ONE SINGLE
; BIT OUT OF THE FOUR BUTTON BITS IS TESTED.
;-------------------------------------------------------------------

        MOV     BL,010H         ;START WITH HIGH BIT IN BIT 4
        CMP     [BP].STIK_NO,2  ;ARE WE TESTING FOR JOYSTICK #2?
        JNE     WHICH           ;IF NOT, GO ON TO TEST FOR WHICH BUTTON,
        SHL     BL,1            ; OTHERWISE SHIFT TWO POSITIONS LEFTWARD
        SHL     BL,1            ; SO THAT THE MASK IS ON BIT 6 FOR STICK 2

WHICH:  CMP     [BP].BTN_NO,2   ;ARE WE TESTING FOR BUTTON #2?
        JNE     READEM          ;IF NOT, MASK IS CORRECT; GO READ PORT
        SHL     BL,1            ;OTHERWISE, SHIFT 1 BIT LEFT FOR BUTTON 2

;------------------------------------------------------------------------
; THE BIT MASK IS NOW CORRECT.  HERE THE BUTTON BITS ARE READ FROM PORT
; $201 AND TESTED AGAINST THE MASK.  NOTE THAT THE BITS AS READ FROM
; THE PORT MUST BE INVERTED SO THAT THE Z FLAG IS SET RATHER THAN CLEARED
; ON AN ACTIVE BUTTON BIT.  (BITS ARE ACTIVE **LOW**, REMEMBER!)
;------------------------------------------------------------------------

READEM: MOV     DX,0201H        ;SET UP 16-BIT ADDRESS FOR PORT READ
        IN      AL,DX           ;READ BUTTON BITS FROM PORT $201
        NOT     AL              ;MUST INVERT BITS FOR PROPER SENSE
                                ; OF THE Z FLAG AFTER TESTING
        TEST    AL,BL           ;SEE IF THE DESIRED BIT IS HIGH;
        JNZ     PUSHED          ;IF SO, BUTTON IS PUSHED;
        MOV     AL,0            ;ELSE MOVE BOOLEAN FALSE INTO AL
        JMP     DONE            ;AND GET OUT OF HERE

PUSHED: MOV     AL,1            ;BUTTON DOWN; MOVE BOOLEAN TRUE INTO AL

DONE:   MOV     SP,BP           ;RESTORE PRIOR STACK POINTER & BP
        POP     BP              ; IN CONVENTIONAL RETURN
        RET     6

BUTTON  ENDP
CODE    ENDS
        END
