{--------------------------------------------------------------}
{                          BoxTest                             }
{                                                              }
{              Character box draw demo program                 }
{                                                              }
{                             by Jeff Duntemann                }
{                             Turbo Pascal V5.0                }
{                             Last update 7/14/88              }
{                                                              }
{     From: COMPLETE TURBO PASCAL 5.0  by Jeff Duntemann       }
{    Scott, Foresman & Co., Inc. 1988   ISBN 0-673-38355-5     }
{--------------------------------------------------------------}

PROGRAM BoxTest;

USES Crt;

TYPE
  GrafRec = RECORD
              ULCorner,
              URCorner,
              LLCorner,
              LRCorner,
              HBar,
              VBar,
              LineCross,
              TDown,
              TUp,
              TRight,
              TLeft : String[4]
            END;

     String80  = String[80];


VAR
  GrafChars    : GrafRec;
  X,Y          : Integer;
  Width,Height : Integer;


PROCEDURE DefineChars(VAR GrafChars : GrafRec);

BEGIN
  WITH GrafChars DO
    BEGIN
      ULCorner  := Chr(201);
      URCorner  := Chr(187);
      LLCorner  := Chr(200);
      LRCorner  := Chr(188);
      HBar      := Chr(205);
      VBar      := Chr(186);
      LineCross := Chr(206);
      TDown     := Chr(203);
      TUp       := Chr(202);
      TRight    := Chr(185);
      TLeft     := Chr(204)
    END
END;


PROCEDURE MakeBox(X,Y,Width,Height : Integer;
                  GrafChars        : GrafRec);

VAR
  I,J : Integer;

BEGIN
  IF X < 0 THEN X := (80-Width) DIV 2;    { Negative X centers box }
  WITH GrafChars DO
    BEGIN                                 { Draw top line }
      GotoXY(X,Y); Write(ULCorner);
      FOR I := 3 TO Width DO Write(HBar);
      Write(URCorner);
                                          { Draw bottom line }
      GotoXY(X,(Y+Height)-1); Write(LLCorner);
      FOR I := 3 TO Width DO Write(HBar);
      Write(LRCorner);
                                          { Draw sides }
      FOR I := 1 TO Height-2 DO
        BEGIN
          GotoXY(X,Y+I); Write(VBar);
          GotoXY((X+Width)-1,Y+I); Write(VBar)
        END
    END
END;



BEGIN
  Randomize;                 { Seed the pseudorandom number generator }
  ClrScr;                    { Clear the entire screen }
  DefineChars(GrafChars);    { Go get box-draw characters for this machine }
  WHILE NOT KeyPressed DO    { Draw boxes until a key is pressed }
    BEGIN
      X := Random(72);       { Get a Random X/Y for UL Corner of box }
      Y := Random(21);
      REPEAT Width := Random(80-72) UNTIL Width > 1;  { Get Random Height & }
      REPEAT Height := Random(25-Y) UNTIL Height > 1; { Width to fit on CRT }
      MakeBox(X,Y,Width,Height,GrafChars);            { and draw it! }
    END
END.
