{}
{   \\\                                    }
{  -(j)-                                   }
{    /juanca                               }
{    ~                                     }
{    ACASA 1989-1992, All rights reserved }
{}

UNIT FNAMEDLG;
{$C MOVEABLE DEMANDLOAD DISCARDABLE}
INTERFACE
  USES
    WINTYPES,
    OBJECTS,
    OWINDOWS,
    ODIALOGS,
    COMMDLG,
    COMONDLG;


  TYPE
    pFileNameDlg = ^tFileNameDlg;
    tFileNameDlg = OBJECT ( tCommonDlg )

      openFileName :tOpenFileName;
      filePath,
      fileName     :tCString;
      toOpen       :Boolean; 


      CONSTRUCTOR
      init(iparent:PWindowsObject; name :PChar; iToOpen :Boolean);

      FUNCTION
      defSpec :PChar;
        virtual;

      FUNCTION
      defExt :PChar;
        virtual;

      FUNCTION
      defSpecPos:Byte;
        virtual;

      FUNCTION
      openFlags :Longint;
        virtual;

      FUNCTION
      doExec:Boolean;
        virtual;

      FUNCTION
      execute:Integer;
        virtual;

    END;

{****************************************************************}
IMPLEMENTATION


      CONSTRUCTOR
      tFileNameDlg.
      {}
      init(iparent:PWindowsObject; name :PChar; iToOpen :Boolean);
        begin
          inherited init(iparent, name);
          toOpen := iToOpen;
          fillChar(filePath, sizeOf(filePath), #0);
          fillChar(fileName, sizeOf(fileName), #0);
          FillChar(openFileName, SizeOf(TOpenFileName), #0);
        end;

      FUNCTION
      tFileNameDlg.
      {}
      defSpec :PChar;
        begin
          defSpec := 'All Files (*.*)'#0'*.*'#0'Override this(!@$%.#%!)'#0'!@$%.#%!'#0'TextFiles (*.txt)'#0'*.txt'#0
        end;

      FUNCTION
      tFileNameDlg.
      {}
      defSpecPos:Byte;
        begin
          defSpecPos := 1 {of the specifiers given ind 'defSpec', which is default, 1 is first}
        end;

      FUNCTION
      tFileNameDlg.
      {}
      defExt :PChar;
        begin
          defExt := 'txt'  {override this to be the your default extension
                            extension SHOULD NOT CONTAIN A PERIOD '.'}
        end;

      FUNCTION
      tFileNameDlg.
      {}
      openFlags:Longint;
        begin
            { this can be set to any OFN_ flags, but don't use the template related ones}
          if toOpen
          then
            openFlags := OFN_PATHMUSTEXIST or OFN_HIDEREADONLY
          else
            openFlags := OFN_PATHMUSTEXIST or OFN_HIDEREADONLY
                                           or OFN_NOREADONLYRETURN
        end;

      FUNCTION
      tFileNameDlg.
      {}
      doExec:Boolean;
        begin
          if toOpen
          then
            doExec := getOpenFileName(openFileName)
          else
            doExec := getSaveFileName(openFileName)
        end;


      FUNCTION
      tFileNameDlg.
      {}
      execute:Integer;
        var
          result :Integer;
          oldKBHandler :pWindowsObject;
        begin
          with openFileName do
          begin
            lStructSize   := sizeof(openFileName);
            hInstance     := SYSTEM.HInstance;
            if parent <> nil
            then
              hwndOwner   := parent^.hWindow
            else
              hwndOwner   := 0;
            lpstrTitle    := dlgTitle;
            lpTemplateName:= attr.Name;
            lpstrFilter   := defSpec;
            nFilterIndex  := defSpecPos;       {Index into Filter String in lpstrFilter}
            lpstrDefExt   := defExt;
            lpstrFile     := filePath;
            lpstrFileTitle:= fileName;
            flags         := openFlags;
            if (lpTemplateName <> nil)
            then
              flags := flags or OFN_ENABLETEMPLATE
            else
              lpTemplateName := nil;
            nMaxFile      := sizeOf(filePath);
            nMaxFileTitle := sizeOf(fileName);

            lCustData    := Longint(@Self);  {this does nothing, but could be usefull}

            move(Self.instance, lpfnHook, sizeOf(lpfnHook)); {this does the trick!}

            flags := flags or OFN_ENABLEHOOK 
          end;

          oldKbHandler := Application^.KBHandlerWnd;
          isModal      := TRUE;  { this is very important, object gets freed twice otherwise !}
          if doExec
          then
            execute := id_Ok
          else begin
            result := commDlgExtendedError;
            if result = 0
            then
              execute := id_Cancel
            else begin
              execute := -result;
              status  := em_InvalidWindow
            end;
          end;
          hwindow := 0;
          isModal := FALSE;
          Application^.KBHandlerWnd := OldKbHandler;
        end;


END.