{}
{   \\\                                    }
{  -(j)-                                   }
{    /juanca                               }
{    ~                                     }
{    ACASA 1989-1992, All rights reserved }
{}

{ tMyPrinter, showing how to override tPrinter to show your own dialogs }

UNIT MYPRN_;
{$C MOVEABLE DEMANDLOAD DISCARDABLE}
INTERFACE
  USES
    PRN31_;

  TYPE
    tMyPrinter = OBJECT(tPrinter)
       useBWCC :Boolean;

       CONSTRUCTOR
       init;

       PROCEDURE
       setBWCCuse(onOff :Boolean);

       FUNCTION
       setupTemplate :PChar;
         virtual;

       FUNCTION
       optionsTemplate :PChar;
         virtual;

       FUNCTION
       abortTemplate :PChar;
         virtual;
    END;


{****************************************************************}
IMPLEMENTATION

       CONSTRUCTOR
       tMyPrinter.
       {}
       init;
         begin
           inherited init;
           useBWCC := FALSE
         end;

       PROCEDURE
       tMyPrinter.
       {}
       setBWCCuse(onOff :Boolean);
         begin
           useBWCC := onOff
         end;

       FUNCTION
       tMyPrinter.
       {}
       setupTemplate :PChar;
         begin
           if useBWCC
           then
             setupTemplate := 'PRINTSETUP31'
           else
             setupTemplate := inherited setupTemplate
         end;


       FUNCTION
       tMyPrinter.
       {}
       optionsTemplate :PChar;
         begin
           if useBWCC
           then
             optionsTemplate := 'PRINTOPT31'
           else
             optionsTemplate := inherited optionsTemplate
         end;

       FUNCTION
       tMyPrinter.
       {}
       abortTemplate :PChar;
         begin
           abortTemplate := inherited abortTemplate
         end;
END.