
PROGRAM ColorTst;

{  This program tests the new color prompting unit, including both color pick
   windows (1x1 and 2x2) and the color->English conversions. }

USES Dos, TPcrt, TPstring, TPstrDev, TPmouse, ColorPrm;

VAR
   Done : BOOLEAN;
   Color : BYTE;
   SavedAttribute : BYTE;

   OldDOSdate,
   OldDOStime : ARRAY [ 1 .. 4 ] OF WORD;


PROCEDURE UpdateDate;
{  This procedure maintains the date display on the screen.  This is called
   from within the UpdateTime routine at midnight and by the main routine. }
CONST
   MonthName : ARRAY[ 1 .. 12 ] OF STRING[ 3 ] = ( 'Jan', 'Feb', 'Mar', 'Apr',
               'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec' );
VAR
   TempDate : ARRAY[ 1 .. 4 ] OF WORD;
   TempString : STRING;
BEGIN
   GetDate( TempDate[1], TempDate[2], TempDate[3], TempDate[4] );
   IF ( TempDate[1] <> OldDOSdate[1] ) OR
      ( TempDate[2] <> OldDOSdate[2] ) OR
      ( TempDate[3] <> OldDOSdate[3] )
   THEN BEGIN { save new date and write date to window }
      OldDOSdate[1] := TempDate[1];
      OldDOSdate[2] := TempDate[2];
      OldDOSdate[3] := TempDate[3];
      OldDOSdate[4] := TempDate[4];
      Write( TpStr, TempDate[3] );
      ReadStr( TempString );
      TempString := TempString + ' ' + MonthName[ TempDate[2] ] + ' ';
      Write( TpStr, TempDate[1] );
      TempString := LeftPad( TempString + ReturnStr, 14 );
      FastWrite( TempString, 2, 65, $1E );
   END { THEN write date to window }
END { PROCEDURE UpdateDate };


PROCEDURE UpdateTime;
{  This procedure maintains the time display on the screen.  This is called
   within the main program and within the keyboard background process. }
VAR
   TempTime : ARRAY[ 1 .. 4 ] OF WORD;
BEGIN
   GetTime( TempTime[1], TempTime[2], TempTime[3], TempTime[4] );
   IF ( TempTime[1] <> OldDOStime[1] ) OR
      ( TempTime[2] <> OldDOStime[2] ) OR
      ( TempTime[3] <> OldDOStime[3] )
   THEN BEGIN { save new time and write time to window }
      OldDOStime[1] := TempTime[1];
      OldDOStime[2] := TempTime[2];
      OldDOStime[3] := TempTime[3];
      OldDOStime[4] := TempTime[4];
      Write( TpStr, TempTime[1] DIV 10, TempTime[1] MOD 10, ':',
                    TempTime[2] DIV 10, TempTime[2] MOD 10, ':',
                    TempTime[3] DIV 10, TempTime[3] MOD 10 );
      FastWrite( ReturnStr, 1, 71, $1E )
   END { THEN write time to window }
END { PROCEDURE UpdateTime };


{$F+ - force far calls to be on for this function }
FUNCTION Scheduler : WORD;
{  This function waits for a key.  While waiting, it calls UpdateDate and
   UpdateTime to maintain the date and time displays on the window.  It returns
   the key code as a word: low order is the ASCII code and high order is the
   scan code (and the word may either be a key or mouse button press). }
BEGIN
   REPEAT
      UpdateDate;
      UpdateTime
   UNTIL KeyPressed OR MousePressed;
   Scheduler := ReadKeyOrButton
END { FUNCTION Scheduler };
{$F- - turn far call forcing off }


BEGIN { PROGRAM ColorTst }
  ClrScr;
  ColorKeyPtr := @Scheduler;
  UpdateDate;
  UpdateTime;
  SavedAttribute := TextAttr;
  Randomize;
  Color := TextAttr;

  EnableEventHandling;

  EnableColorMouse;

  REPEAT
     Done := NOT PromptForColor( Random( 256 ), Random( 81 ), Random( 26 ),
                                 $07, $70, ' Random Color ', [ #27, #13 ],
                                 Color );
     TextAttr := Color;
     IF NOT Done
     THEN WriteLn( 'Next color is  $', HexB( Color ), ' (', Color,
                   '), which is ', FullColorString( Color ) )
  UNTIL Done;

  REPEAT
     Done := NOT BigPromptForColor( Random( 256 ), Random( 81 ), Random( 26 ),
                                    $07, $70, ' Random Color ', [ #27, #13 ],
                                    Color );
     TextAttr := Color;
     IF NOT Done
     THEN WriteLn( 'Next color is $', HexB( Color ), ' (', Color,
                   '), which is ', FullColorString( Color ) )
  UNTIL Done;

  TextAttr := SavedAttribute;
  ClrScr
END { PROGRAM ColorTst }.
